/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler;

import java.util.List;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.function.compiler.CompiledFunctionFactory;
import org.springframework.cloud.function.compiler.java.CompilationFailedException;
import org.springframework.cloud.function.compiler.java.CompilationMessage;
import org.springframework.cloud.function.compiler.java.CompilationResult;
import org.springframework.cloud.function.compiler.java.RuntimeJavaCompiler;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractFunctionCompiler<F> {
    private static Logger logger = LoggerFactory.getLogger(AbstractFunctionCompiler.class);
    private static final String NEWLINE_ESCAPE = Matcher.quoteReplacement("\\n");
    private static final String DOUBLE_DOUBLE_QUOTE = Matcher.quoteReplacement("\"\"");
    private static String SOURCE_CODE_TEMPLATE = "package " + AbstractFunctionCompiler.class.getPackage().getName() + ";\nimport java.util.*;\nimport java.time.*;\nimport java.util.function.*;\nimport reactor.core.publisher.Flux;\npublic class %s implements CompilationResultFactory<%s> {\n public %s<%s> getResult() {\n  %s\n }\n}\n";
    private final ResultType resultType;
    private final String[] defaultResultTypeParameterizations;
    private final RuntimeJavaCompiler compiler = new RuntimeJavaCompiler();

    AbstractFunctionCompiler(ResultType type, String ... defaultResultTypeParameterizations) {
        this.resultType = type;
        this.defaultResultTypeParameterizations = defaultResultTypeParameterizations;
    }

    public final CompiledFunctionFactory<F> compile(String name, String code, String ... resultTypeParameterizations) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name must not be empty");
        }
        logger.info("Initial code property value :'{}'", (Object)code);
        Object[] parameterizedTypes = !ObjectUtils.isEmpty((Object[])resultTypeParameterizations) ? resultTypeParameterizations : this.defaultResultTypeParameterizations;
        code = AbstractFunctionCompiler.decode(code);
        if (code.startsWith("\"") && code.endsWith("\"")) {
            code = code.substring(1, code.length() - 1);
        }
        if (!code.startsWith("return ") && !code.endsWith(";")) {
            code = String.format("return (%s<%s> & java.io.Serializable) %s;", new Object[]{this.resultType, StringUtils.arrayToCommaDelimitedString((Object[])parameterizedTypes), code});
        }
        logger.info("Processed code property value :\n{}\n", (Object)code);
        String firstLetter = name.substring(0, 1).toUpperCase();
        name = name.length() > 1 ? firstLetter + name.substring(1) : firstLetter;
        String className = String.format("%s.%s%sFactory", new Object[]{this.getClass().getPackage().getName(), name, this.resultType});
        CompilationResult compilationResult = this.buildAndCompileSourceCode(className, code, (String[])parameterizedTypes);
        if (compilationResult.wasSuccessful()) {
            CompiledFunctionFactory factory = new CompiledFunctionFactory(className, compilationResult);
            return this.postProcessCompiledFunctionFactory(factory);
        }
        List<CompilationMessage> compilationMessages = compilationResult.getCompilationMessages();
        throw new CompilationFailedException(compilationMessages);
    }

    protected CompiledFunctionFactory<F> postProcessCompiledFunctionFactory(CompiledFunctionFactory<F> factory) {
        return factory;
    }

    private CompilationResult buildAndCompileSourceCode(String className, String methodBody, String[] parameterizedTypes) {
        String sourceCode = this.makeSourceClassDefinition(className, methodBody, parameterizedTypes);
        return this.compiler.compile(className, sourceCode, new String[0]);
    }

    private static String decode(String input) {
        return input.replaceAll(NEWLINE_ESCAPE, "\n").replaceAll(DOUBLE_DOUBLE_QUOTE, "\"");
    }

    private String makeSourceClassDefinition(String className, String methodBody, String[] types) {
        String shortClassName = className.substring(className.lastIndexOf(46) + 1);
        String s = String.format(SOURCE_CODE_TEMPLATE, new Object[]{shortClassName, this.resultType, this.resultType, StringUtils.arrayToCommaDelimitedString((Object[])types), methodBody});
        logger.info("\n" + s);
        return s;
    }

    static enum ResultType {
        Consumer,
        Function,
        Supplier;

    }
}

