/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.function.compiler.java.CompilationMessage;

public class CompilationResult {
    private boolean successfulCompilation;
    List<CompilationMessage> compilationMessages = new ArrayList<CompilationMessage>();
    List<Class<?>> compiledClasses = new ArrayList();
    private Map<String, byte[]> classBytes = new HashMap<String, byte[]>();
    private List<File> resolvedAdditionalDependencies = new ArrayList<File>();

    public CompilationResult(boolean successfulCompilation) {
        this.successfulCompilation = successfulCompilation;
    }

    public void addClassBytes(String name, byte[] bytes) {
        this.classBytes.put(name, bytes);
    }

    public void setResolvedAdditionalDependencies(List<File> resolvedAdditionalDependencies) {
        this.resolvedAdditionalDependencies = resolvedAdditionalDependencies;
    }

    public List<File> getResolvedAdditionalDependencies() {
        return this.resolvedAdditionalDependencies;
    }

    public byte[] getClassBytes(String classname) {
        return this.classBytes.get(classname);
    }

    public boolean wasSuccessful() {
        return this.successfulCompilation;
    }

    public List<Class<?>> getCompiledClasses() {
        return this.compiledClasses;
    }

    public List<CompilationMessage> getCompilationMessages() {
        return Collections.unmodifiableList(this.compilationMessages);
    }

    public void recordCompilationMessage(CompilationMessage message) {
        this.compilationMessages.add(message);
    }

    public void recordCompilationMessages(List<CompilationMessage> messages) {
        this.compilationMessages.addAll(messages);
    }

    public void setCompiledClasses(List<Class<?>> compiledClasses) {
        this.compiledClasses = compiledClasses;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Compilation result: #classes=" + this.compiledClasses.size() + "  #messages=" + this.compilationMessages.size() + "\n");
        s.append("Compiled classes:\n").append(this.compiledClasses).append("\n");
        s.append("Compilation messages:\n").append(this.compilationMessages).append("\n");
        return s.toString();
    }
}

