/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.core.FluxConsumer;
import org.springframework.cloud.function.core.FluxFunction;
import org.springframework.cloud.function.core.FluxSupplier;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FunctionRegistration<T> {
    private T target;
    private final Set<String> names = new LinkedHashSet<String>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private FunctionType type;

    @Deprecated
    public FunctionRegistration(T target) {
        Assert.notNull(target, (String)"'target' must not be null");
        this.target = target;
    }

    public FunctionRegistration(T target, String ... names) {
        Assert.notNull(target, (String)"'target' must not be null");
        Assert.notEmpty((Object[])names, (String)"'names' must not be null or empty");
        this.target = target;
        this.names(names);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public FunctionType getType() {
        return this.type;
    }

    public void setNames(Set<String> names) {
        this.names.clear();
        this.names.addAll(names);
    }

    public T getTarget() {
        return this.target;
    }

    public FunctionRegistration<T> properties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public FunctionRegistration<T> type(Type type) {
        this.type = FunctionType.of(type);
        return this;
    }

    public FunctionRegistration<T> type(FunctionType type) {
        this.type = type;
        return this;
    }

    public FunctionRegistration<T> target(T target) {
        this.target = target;
        return this;
    }

    public FunctionRegistration<T> name(String name) {
        return this.names(name);
    }

    public FunctionRegistration<T> names(Collection<String> names) {
        this.names.addAll(names);
        return this;
    }

    public FunctionRegistration<T> names(String ... names) {
        return this.names(Arrays.asList(names));
    }

    public <S> FunctionRegistration<S> wrap() {
        if (this.type == null || this.type.isWrapper()) {
            FunctionRegistration value = this;
            return value;
        }
        Object target = this.target;
        FunctionRegistration<T> result = new FunctionRegistration<T>(target);
        result.type(this.type.getType());
        if (target instanceof Function) {
            FluxFunction wrapped = new FluxFunction((Function)target);
            target = wrapped;
            result.type = result.type.wrap(Flux.class);
        } else if (target instanceof Supplier) {
            FluxSupplier wrapped = new FluxSupplier((Supplier)target);
            target = wrapped;
            result.type = result.type.wrap(Flux.class);
        } else if (target instanceof Consumer) {
            FluxConsumer wrapped = new FluxConsumer((Consumer)target);
            target = wrapped;
            result.type = result.type.wrap(Flux.class, Mono.class);
        }
        return result.target(target).names(this.names).properties(this.properties);
    }
}

