/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetadata;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.InMemoryFunctionCatalog;
import org.springframework.cloud.function.context.config.ContextFunctionCatalogAutoConfiguration;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.ClassUtils;

public class ContextFunctionCatalogInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    public void initialize(GenericApplicationContext applicationContext) {
        if (((Boolean)applicationContext.getEnvironment().getProperty("spring.functional.enabled", Boolean.class, (Object)false)).booleanValue()) {
            ContextFunctionCatalogBeanRegistrar registrar = new ContextFunctionCatalogBeanRegistrar(applicationContext);
            applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)registrar);
        }
    }

    static class ContextFunctionCatalogBeanRegistrar
    implements BeanDefinitionRegistryPostProcessor {
        private GenericApplicationContext context;

        public ContextFunctionCatalogBeanRegistrar(GenericApplicationContext applicationContext) {
            this.context = applicationContext;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            try {
                this.register(registry, (ConfigurableListableBeanFactory)this.context.getDefaultListableBeanFactory());
            }
            catch (BeansException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BeanCreationException("Cannot register from " + this.getClass(), (Throwable)e);
            }
        }

        protected void register(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory factory) throws Exception {
            this.performPreinitialization();
            this.context.registerBean(PropertySourcesPlaceholderConfigurer.class, () -> PropertyPlaceholderAutoConfiguration.propertySourcesPlaceholderConfigurer(), new BeanDefinitionCustomizer[0]);
            this.context.registerBean("org.springframework.context.annotation.internalAutowiredAnnotationProcessor", AutowiredAnnotationBeanPostProcessor.class, new BeanDefinitionCustomizer[0]);
            this.context.registerBean(ConfigurationBeanFactoryMetadata.BEAN_NAME, ConfigurationBeanFactoryMetadata.class, () -> new ConfigurationBeanFactoryMetadata(), new BeanDefinitionCustomizer[0]);
            this.context.registerBean(ConfigurationPropertiesBindingPostProcessor.BEAN_NAME, ConfigurationPropertiesBindingPostProcessor.class, () -> new ConfigurationPropertiesBindingPostProcessor(), new BeanDefinitionCustomizer[0]);
            if (ClassUtils.isPresent((String)"com.google.gson.Gson", null) && !"gson".equals(this.context.getEnvironment().getProperty("spring.http.converters.preferred-json-mapper", "gson"))) {
                if (this.context.getBeanNamesForType(Gson.class, false, false).length == 0) {
                    this.context.registerBean(Gson.class, () -> new Gson(), new BeanDefinitionCustomizer[0]);
                }
                this.context.registerBean(JsonMapper.class, () -> new ContextFunctionCatalogAutoConfiguration.GsonConfiguration().jsonMapper((Gson)this.context.getBean(Gson.class)), new BeanDefinitionCustomizer[0]);
            } else if (ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper.ObjectMapper", null)) {
                if (this.context.getBeanNamesForType(ObjectMapper.class, false, false).length == 0) {
                    this.context.registerBean(ObjectMapper.class, () -> new ObjectMapper(), new BeanDefinitionCustomizer[0]);
                }
                this.context.registerBean(JsonMapper.class, () -> new ContextFunctionCatalogAutoConfiguration.JacksonConfiguration().jsonMapper((ObjectMapper)this.context.getBean(ObjectMapper.class)), new BeanDefinitionCustomizer[0]);
            }
            this.context.registerBean(InMemoryFunctionCatalog.class, () -> new InMemoryFunctionCatalog(), new BeanDefinitionCustomizer[0]);
            this.context.registerBean(FunctionRegistrationPostProcessor.class, () -> new FunctionRegistrationPostProcessor((FunctionRegistry)this.context.getBean(FunctionRegistry.class)), new BeanDefinitionCustomizer[0]);
        }

        private void performPreinitialization() {
            try {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        this.runSafely(() -> new DefaultFormattingConversionService());
                    }

                    public void runSafely(Runnable runnable) {
                        try {
                            runnable.run();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }, "background-preinit");
                thread.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private class FunctionRegistrationPostProcessor
        implements BeanPostProcessor {
            private final FunctionRegistry catalog;

            public FunctionRegistrationPostProcessor(FunctionRegistry catalog) {
                this.catalog = catalog;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof FunctionRegistration) {
                    FunctionRegistration registration = (FunctionRegistration)bean;
                    if (registration.getNames().isEmpty()) {
                        registration = registration.name(beanName);
                    }
                    if (registration.getType() == null) {
                        throw new IllegalStateException("You need an explicit type for the function: " + beanName);
                    }
                    this.catalog.register(registration);
                }
                return bean;
            }
        }
    }
}

