/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"kotlin.jvm.functions.Function1"})
class KotlinLambdaToFunctionAutoConfiguration
implements BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableListableBeanFactory beanFactory;

    KotlinLambdaToFunctionAutoConfiguration() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Bean
    public BeanPostProcessor kotlinPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof Function1) {
                    FunctionType functionType = FunctionContextUtils.findType(beanName, KotlinLambdaToFunctionAutoConfiguration.this.beanFactory);
                    if (Unit.class.isAssignableFrom(functionType.getOutputType())) {
                        KotlinLambdaToFunctionAutoConfiguration.this.logger.debug((Object)("Transforming Kotlin lambda " + beanName + " to java Consumer"));
                        KotlinConsumer consumer = new KotlinConsumer(bean);
                        bean = consumer;
                    } else {
                        KotlinFunction function;
                        KotlinLambdaToFunctionAutoConfiguration.this.logger.debug((Object)("Transforming Kotlin lambda " + beanName + " to java Function"));
                        bean = function = new KotlinFunction(bean);
                    }
                } else if (bean instanceof Function0) {
                    KotlinLambdaToFunctionAutoConfiguration.this.logger.debug((Object)("Transforming Kotlin lambda " + beanName + " to java Supplier"));
                    KotlinSupplier supplier = new KotlinSupplier((Function0)bean);
                    bean = supplier;
                }
                return bean;
            }
        };
    }

    private static class KotlinSupplier<O>
    implements Supplier<O>,
    Function0<O> {
        private final Function0<O> kotlinLambda;

        KotlinSupplier(Function0<O> kotlinLambda) {
            this.kotlinLambda = kotlinLambda;
        }

        @Override
        public O get() {
            return this.invoke();
        }

        public O invoke() {
            return (O)this.kotlinLambda.invoke();
        }
    }

    private static class KotlinConsumer<I, U>
    implements Consumer<I>,
    Function1<I, U> {
        private final Function1<I, U> kotlinLambda;

        KotlinConsumer(Function1<I, U> kotlinLambda) {
            this.kotlinLambda = kotlinLambda;
        }

        public U invoke(I i) {
            return (U)this.kotlinLambda.invoke(i);
        }

        @Override
        public void accept(I i) {
            this.kotlinLambda.invoke(i);
        }
    }

    private static class KotlinFunction<I, O>
    implements Function<I, O>,
    Function1<I, O> {
        private final Function1<I, O> kotlinLambda;

        KotlinFunction(Function1<I, O> kotlinLambda) {
            this.kotlinLambda = kotlinLambda;
        }

        @Override
        public O apply(I i) {
            return (O)this.kotlinLambda.invoke(i);
        }

        public O invoke(I i) {
            return this.apply(i);
        }
    }
}

