/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.mvc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class ServletOutputToInputConverter
extends HttpServletResponseWrapper {
    private StringBuilder builder = new StringBuilder();

    public ServletOutputToInputConverter(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
                ServletOutputToInputConverter.this.builder.append(new Character((char)b));
            }

            public void setWriteListener(WriteListener listener) {
            }

            public boolean isReady() {
                return true;
            }
        };
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream body = new ByteArrayInputStream(this.builder.toString().getBytes());
        return new ServletInputStream(){

            public int read() throws IOException {
                return body.read();
            }

            public void setReadListener(ReadListener listener) {
            }

            public boolean isReady() {
                return true;
            }

            public boolean isFinished() {
                return body.available() <= 0;
            }
        };
    }
}

