/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.rsocket.RSocket;
import io.rsocket.SocketAcceptor;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.rsocket.RSocketServerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.rsocket.server.RSocketServerBootstrap;
import org.springframework.boot.rsocket.server.RSocketServerFactory;
import org.springframework.cloud.gateway.rsocket.autoconfigure.GatewayRSocketProperties;
import org.springframework.cloud.gateway.rsocket.core.GatewayRSocket;
import org.springframework.cloud.gateway.rsocket.core.GatewayServerRSocketFactoryCustomizer;
import org.springframework.cloud.gateway.rsocket.registry.Registry;
import org.springframework.cloud.gateway.rsocket.registry.RegistryRoutes;
import org.springframework.cloud.gateway.rsocket.registry.RegistrySocketAcceptorFilter;
import org.springframework.cloud.gateway.rsocket.route.Routes;
import org.springframework.cloud.gateway.rsocket.socketacceptor.GatewaySocketAcceptor;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorFilter;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorPredicate;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorPredicateFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.gateway.rsocket.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties
@ConditionalOnClass(value={RSocket.class})
@AutoConfigureBefore(value={RSocketServerAutoConfiguration.class})
public class GatewayRSocketAutoConfiguration {
    @Bean
    public Registry registry() {
        return new Registry();
    }

    @Bean
    public RegistryRoutes registryRoutes(Registry registry) {
        RegistryRoutes registryRoutes = new RegistryRoutes();
        registry.addListener(registryRoutes);
        return registryRoutes;
    }

    @Bean
    public RegistrySocketAcceptorFilter registrySocketAcceptorFilter(Registry registry) {
        return new RegistrySocketAcceptorFilter(registry);
    }

    @Bean
    public GatewayRSocket.Factory gatewayRSocketFactory(Registry registry, Routes routes, MeterRegistry meterRegistry, GatewayRSocketProperties properties) {
        return new GatewayRSocket.Factory(registry, routes, meterRegistry, properties);
    }

    @Bean
    public GatewayRSocketProperties gatewayRSocketProperties(Environment env) {
        GatewayRSocketProperties properties = new GatewayRSocketProperties();
        if (env.containsProperty("spring.application.name")) {
            properties.setId(env.getProperty("spring.application.name"));
        }
        return properties;
    }

    @Bean
    public SocketAcceptorPredicateFilter socketAcceptorPredicateFilter(List<SocketAcceptorPredicate> predicates) {
        return new SocketAcceptorPredicateFilter(predicates);
    }

    @Bean
    public GatewaySocketAcceptor socketAcceptor(GatewayRSocket.Factory rsocketFactory, List<SocketAcceptorFilter> filters, MeterRegistry meterRegistry, GatewayRSocketProperties properties) {
        return new GatewaySocketAcceptor(rsocketFactory, filters, meterRegistry, properties);
    }

    @Bean
    public GatewayServerRSocketFactoryCustomizer gatewayServerRSocketFactoryCustomizer(GatewayRSocketProperties properties, MeterRegistry meterRegistry) {
        return new GatewayServerRSocketFactoryCustomizer(properties, meterRegistry);
    }

    @Bean
    public RSocketServerBootstrap gatewayRSocketServerBootstrap(RSocketServerFactory rSocketServerFactory, GatewaySocketAcceptor gatewaySocketAcceptor) {
        return new RSocketServerBootstrap(rSocketServerFactory, (SocketAcceptor)gatewaySocketAcceptor);
    }
}

