/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.autoconfigure;

import java.util.Collections;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class GatewayRSocketEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment env, SpringApplication application) {
        Boolean enabled = (Boolean)env.getProperty("spring.cloud.gateway.rsocket.enabled", Boolean.class, (Object)true);
        if (enabled.booleanValue() && !env.containsProperty("spring.rsocket.server.port")) {
            Map<String, Integer> map = Collections.singletonMap("spring.rsocket.server.port", 7002);
            env.getPropertySources().addLast((PropertySource)new MapPropertySource("Default Gateway RSocket Port", map));
        }
    }
}

