/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.core;

import io.micrometer.core.instrument.Tags;
import io.rsocket.Payload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.rsocket.filter.AbstractRSocketExchange;
import org.springframework.cloud.gateway.rsocket.support.Metadata;

public class GatewayExchange
extends AbstractRSocketExchange {
    private static final Log log = LogFactory.getLog(GatewayExchange.class);
    public static final String ROUTE_ATTR = "__route_attr_";
    private final Type type;
    private final Metadata routingMetadata;
    private Tags tags = Tags.empty();

    public static GatewayExchange fromPayload(Type type, Payload payload) {
        return new GatewayExchange(type, GatewayExchange.getRoutingMetadata(payload));
    }

    private static Metadata getRoutingMetadata(Payload payload) {
        if (payload == null || !payload.hasMetadata()) {
            return null;
        }
        Metadata metadata = Metadata.decodeMetadata(payload.sliceMetadata());
        if (log.isDebugEnabled()) {
            log.debug((Object)("found routing metadata " + metadata));
        }
        return metadata;
    }

    public GatewayExchange(Type type, Metadata routingMetadata) {
        this.type = type;
        this.routingMetadata = routingMetadata;
    }

    public Type getType() {
        return this.type;
    }

    public Metadata getRoutingMetadata() {
        return this.routingMetadata;
    }

    public Tags getTags() {
        return this.tags;
    }

    public void setTags(Tags tags) {
        this.tags = tags;
    }

    static enum Type {
        FIRE_AND_FORGET("request.fnf"),
        REQUEST_CHANNEL("request.channel"),
        REQUEST_RESPONSE("request.response"),
        REQUEST_STREAM("request.stream");

        private String key;

        private Type(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }
}

