/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.core;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.rsocket.RSocketFactory;
import io.rsocket.micrometer.MicrometerDuplexConnectionInterceptor;
import io.rsocket.plugins.DuplexConnectionInterceptor;
import io.rsocket.plugins.RSocketInterceptor;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.rsocket.server.ServerRSocketFactoryCustomizer;
import org.springframework.cloud.gateway.rsocket.autoconfigure.GatewayRSocketProperties;
import org.springframework.util.Assert;

public class GatewayServerRSocketFactoryCustomizer
implements ServerRSocketFactoryCustomizer {
    private static final Log log = LogFactory.getLog(GatewayServerRSocketFactoryCustomizer.class);
    private static final RSocketInterceptor[] EMPTY_INTERCEPTORS = new RSocketInterceptor[0];
    private final GatewayRSocketProperties properties;
    private final List<RSocketInterceptor> serverInterceptors;
    private final MeterRegistry meterRegistry;

    public GatewayServerRSocketFactoryCustomizer(GatewayRSocketProperties properties, MeterRegistry meterRegistry) {
        this(properties, meterRegistry, EMPTY_INTERCEPTORS);
    }

    public GatewayServerRSocketFactoryCustomizer(GatewayRSocketProperties properties, MeterRegistry meterRegistry, RSocketInterceptor ... interceptors) {
        Assert.notNull((Object)properties, (String)"properties may not be null");
        Assert.notNull((Object)meterRegistry, (String)"meterRegistry may not be null");
        Assert.notNull((Object)interceptors, (String)"interceptors may not be null");
        this.properties = properties;
        this.meterRegistry = meterRegistry;
        this.serverInterceptors = Arrays.asList(interceptors);
    }

    public RSocketFactory.ServerRSocketFactory apply(RSocketFactory.ServerRSocketFactory factory) {
        this.serverInterceptors.forEach(arg_0 -> ((RSocketFactory.ServerRSocketFactory)factory).addResponderPlugin(arg_0));
        List<String> micrometerTags = this.properties.getMicrometerTags();
        Tag[] tags = Tags.of((String[])micrometerTags.toArray(new String[0])).and("gateway.id", this.properties.getId()).stream().collect(Collectors.toList()).toArray(new Tag[0]);
        return factory.addConnectionPlugin((DuplexConnectionInterceptor)new MicrometerDuplexConnectionInterceptor(this.meterRegistry, tags)).errorConsumer(throwable -> {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error with connection", throwable);
            }
        });
    }
}

