/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.filter;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.rsocket.filter.FilterChain;
import org.springframework.cloud.gateway.rsocket.filter.RSocketExchange;
import org.springframework.cloud.gateway.rsocket.filter.RSocketFilter;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public abstract class AbstractFilterChain<F extends RSocketFilter, E extends RSocketExchange, FC extends AbstractFilterChain>
implements FilterChain<E> {
    private final Log log = LogFactory.getLog(this.getClass());
    protected final List<F> allFilters;
    @Nullable
    protected final F currentFilter;
    @Nullable
    protected final FC next;
    private static final Mono<RSocketFilter.Success> MONO_SUCCESS = Mono.just((Object)((Object)RSocketFilter.Success.INSTANCE));

    protected AbstractFilterChain(List<F> filters) {
        this.allFilters = Collections.unmodifiableList(filters);
        FC chain = this.initChain(filters);
        this.currentFilter = ((AbstractFilterChain)chain).currentFilter;
        this.next = ((AbstractFilterChain)chain).next;
    }

    private FC initChain(List<F> filters) {
        Object chain = this.create(filters, null, null);
        ListIterator<F> iterator = filters.listIterator(filters.size());
        while (iterator.hasPrevious()) {
            chain = this.create(filters, (RSocketFilter)iterator.previous(), chain);
        }
        return chain;
    }

    protected AbstractFilterChain(List<F> allFilters, @Nullable F currentFilter, @Nullable FC next) {
        this.allFilters = allFilters;
        this.currentFilter = currentFilter;
        this.next = next;
    }

    protected abstract FC create(List<F> var1, @Nullable F var2, @Nullable FC var3);

    public List<F> getFilters() {
        return this.allFilters;
    }

    @Override
    public Mono<RSocketFilter.Success> filter(E exchange) {
        return Mono.defer(() -> this.currentFilter != null && this.next != null ? this.currentFilter.filter((RSocketExchange)exchange, this.next) : this.getMonoSuccess());
    }

    private Mono<RSocketFilter.Success> getMonoSuccess() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"filter chain completed with success");
        }
        return MONO_SUCCESS;
    }
}

