/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.filter;

import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RSocketExchange {
    public Map<String, Object> getAttributes();

    @Nullable
    default public <T> T getAttribute(String name) {
        return (T)this.getAttributes().get(name);
    }

    default public <T> T getRequiredAttribute(String name) {
        T value = this.getAttribute(name);
        Assert.notNull(value, () -> "Required attribute '" + name + "' is missing");
        return value;
    }

    default public <T> T getAttributeOrDefault(String name, T defaultValue) {
        return (T)this.getAttributes().getOrDefault(name, defaultValue);
    }
}

