/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.ResponderRSocket;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class MicrometerResponderRSocket
implements ResponderRSocket {
    private static final Log log = LogFactory.getLog(MicrometerResponderRSocket.class);
    private final RSocket delegate;
    private final InteractionCounters metadataPush;
    private final InteractionCounters requestChannel;
    private final InteractionCounters requestFireAndForget;
    private final InteractionTimers requestResponse;
    private final InteractionCounters requestStream;

    public MicrometerResponderRSocket(RSocket delegate, MeterRegistry meterRegistry, Tag ... tags) {
        Assert.notNull((Object)delegate, (String)"delegate must not be null");
        Assert.notNull((Object)meterRegistry, (String)"meterRegistry must not be null");
        this.delegate = delegate;
        this.metadataPush = new InteractionCounters(meterRegistry, "metadata.push", tags);
        this.requestChannel = new InteractionCounters(meterRegistry, "request.channel", tags);
        this.requestFireAndForget = new InteractionCounters(meterRegistry, "request.fnf", tags);
        this.requestResponse = new InteractionTimers(meterRegistry, "request.response", tags);
        this.requestStream = new InteractionCounters(meterRegistry, "request.stream", tags);
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public Mono<Void> fireAndForget(Payload payload) {
        return this.delegate.fireAndForget(payload).doFinally((Consumer)this.requestFireAndForget);
    }

    public Mono<Void> metadataPush(Payload payload) {
        return this.delegate.metadataPush(payload).doFinally((Consumer)this.metadataPush);
    }

    public Mono<Void> onClose() {
        return this.delegate.onClose();
    }

    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.delegate.requestChannel(payloads).doFinally((Consumer)this.requestChannel);
    }

    public Mono<Payload> requestResponse(Payload payload) {
        return Mono.defer(() -> {
            Timer.Sample sample = this.requestResponse.start();
            return this.delegate.requestResponse(payload).doFinally(signalType -> this.requestResponse.accept(sample, (SignalType)signalType));
        });
    }

    public Flux<Payload> requestStream(Payload payload) {
        return this.delegate.requestStream(payload).doFinally((Consumer)this.requestStream);
    }

    public Flux<Payload> requestChannel(Payload payload, Publisher<Payload> payloads) {
        if (this.delegate instanceof ResponderRSocket) {
            ResponderRSocket rSocket = (ResponderRSocket)this.delegate;
            return rSocket.requestChannel(payload, payloads).doFinally((Consumer)this.requestChannel);
        }
        return this.delegate.requestChannel(payloads).doFinally((Consumer)this.requestChannel);
    }

    private static final class InteractionTimers
    implements BiConsumer<Timer.Sample, SignalType> {
        private final Timer cancel;
        private final MeterRegistry meterRegistry;
        private final Timer onComplete;
        private final Timer onError;

        private InteractionTimers(MeterRegistry meterRegistry, String interactionModel, Tag ... tags) {
            this.meterRegistry = meterRegistry;
            this.cancel = InteractionTimers.timer(meterRegistry, interactionModel, SignalType.CANCEL, tags);
            this.onComplete = InteractionTimers.timer(meterRegistry, interactionModel, SignalType.ON_COMPLETE, tags);
            this.onError = InteractionTimers.timer(meterRegistry, interactionModel, SignalType.ON_ERROR, tags);
        }

        @Override
        public void accept(Timer.Sample sample, SignalType signalType) {
            switch (signalType) {
                case CANCEL: {
                    if (this.cancel == null) break;
                    sample.stop(this.cancel);
                    break;
                }
                case ON_COMPLETE: {
                    if (this.onComplete == null) break;
                    sample.stop(this.onComplete);
                    break;
                }
                case ON_ERROR: {
                    if (this.onError == null) break;
                    sample.stop(this.onError);
                }
            }
        }

        Timer.Sample start() {
            return Timer.start((MeterRegistry)this.meterRegistry);
        }

        private static Timer timer(MeterRegistry meterRegistry, String interactionModel, SignalType signalType, Tag ... tags) {
            Tags withType = Tags.of((Tag[])tags).and("signal.type", signalType.name());
            try {
                return meterRegistry.timer("rsocket." + interactionModel, (Iterable)withType);
            }
            catch (Exception e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Error creating timer with tags: " + withType), (Throwable)e);
                }
                return null;
            }
        }
    }

    private static final class InteractionCounters
    implements Consumer<SignalType> {
        private final Counter cancel;
        private final Counter onComplete;
        private final Counter onError;

        private InteractionCounters(MeterRegistry meterRegistry, String interactionModel, Tag ... tags) {
            this.cancel = this.counter(meterRegistry, interactionModel, SignalType.CANCEL, tags);
            this.onComplete = this.counter(meterRegistry, interactionModel, SignalType.ON_COMPLETE, tags);
            this.onError = this.counter(meterRegistry, interactionModel, SignalType.ON_ERROR, tags);
        }

        @Override
        public void accept(SignalType signalType) {
            switch (signalType) {
                case CANCEL: {
                    if (this.cancel == null) break;
                    this.cancel.increment();
                    break;
                }
                case ON_COMPLETE: {
                    if (this.onComplete == null) break;
                    this.onComplete.increment();
                    break;
                }
                case ON_ERROR: {
                    if (this.onError == null) break;
                    this.onError.increment();
                }
            }
        }

        private Counter counter(MeterRegistry meterRegistry, String interactionModel, SignalType signalType, Tag ... tags) {
            Tags withType = Tags.of((Tag[])tags).and("signal.type", signalType.name());
            try {
                return meterRegistry.counter("rsocket." + interactionModel, (Iterable)withType);
            }
            catch (Exception e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Error creating counter with tags: " + withType), (Throwable)e);
                }
                return null;
            }
        }
    }
}

