/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.registry;

import io.rsocket.RSocket;
import io.rsocket.util.RSocketProxy;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.rsocket.support.Metadata;
import reactor.core.publisher.Mono;

public class LoadBalancedRSocket {
    private static final Log log = LogFactory.getLog(LoadBalancedRSocket.class);
    private final List<EnrichedRSocket> delegates = new CopyOnWriteArrayList<EnrichedRSocket>();
    private final String serviceName;
    private final LoadBalancer loadBalancer;

    public LoadBalancedRSocket(String serviceName) {
        this(serviceName, new RoundRobinLoadBalancer(serviceName));
    }

    public LoadBalancedRSocket(String serviceName, LoadBalancer loadBalancer) {
        this.serviceName = serviceName;
        this.loadBalancer = loadBalancer;
    }

    public Mono<EnrichedRSocket> choose() {
        return (Mono)this.loadBalancer.apply(this.delegates);
    }

    public void addRSocket(RSocket rsocket, Metadata metadata) {
        this.delegates.add(new EnrichedRSocket(rsocket, metadata));
    }

    public void remove(Metadata metadata) {
        this.delegates.stream().filter(enriched -> metadata.matches(enriched.getMetadata())).findFirst().ifPresent(this.delegates::remove);
    }

    public List<EnrichedRSocket> getDelegates() {
        return this.delegates;
    }

    public static class RoundRobinLoadBalancer
    implements LoadBalancer {
        private final AtomicInteger position;
        private final String serviceName;

        public RoundRobinLoadBalancer(String serviceName) {
            this(serviceName, new Random().nextInt(1000));
        }

        public RoundRobinLoadBalancer(String serviceName, int seedPosition) {
            this.serviceName = serviceName;
            this.position = new AtomicInteger(seedPosition);
        }

        @Override
        public Mono<EnrichedRSocket> apply(List<EnrichedRSocket> rSockets) {
            if (rSockets.isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("No servers available for: " + this.serviceName));
                }
                return Mono.empty();
            }
            int pos = Math.abs(this.position.incrementAndGet());
            EnrichedRSocket rSocket = rSockets.get(pos % rSockets.size());
            return Mono.just((Object)((Object)rSocket));
        }
    }

    public static interface LoadBalancer
    extends Function<List<EnrichedRSocket>, Mono<EnrichedRSocket>> {
    }

    public static class EnrichedRSocket
    extends RSocketProxy {
        private final Metadata metadata;

        public EnrichedRSocket(RSocket source, Metadata metadata) {
            super(source);
            this.metadata = metadata;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public RSocket getSource() {
            return this.source;
        }
    }
}

