/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.registry;

import io.rsocket.RSocket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.rsocket.registry.LoadBalancedRSocket;
import org.springframework.cloud.gateway.rsocket.support.Metadata;
import org.springframework.util.Assert;
import reactor.core.Disposable;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.FluxSink;

public class Registry {
    private static final Log log = LogFactory.getLog(Registry.class);
    private final Map<String, LoadBalancedRSocket> rsockets = new ConcurrentHashMap<String, LoadBalancedRSocket>();
    private final DirectProcessor<RegisteredEvent> registeredEvents = DirectProcessor.create();
    private final FluxSink<RegisteredEvent> registeredEventsSink = this.registeredEvents.sink(FluxSink.OverflowStrategy.DROP);

    public void register(Metadata metadata, RSocket rsocket) {
        Assert.notNull((Object)metadata, (String)"metadata may not be null");
        Assert.notNull((Object)rsocket, (String)"RSocket may not be null");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering RSocket: " + metadata));
        }
        LoadBalancedRSocket composite = this.rsockets.computeIfAbsent(metadata.getName(), s -> new LoadBalancedRSocket(metadata.getName()));
        composite.addRSocket(rsocket, metadata);
        this.registeredEventsSink.next((Object)new RegisteredEvent(metadata, rsocket));
    }

    public void deregister(Metadata metadata) {
        LoadBalancedRSocket loadBalanced;
        Assert.notNull((Object)metadata, (String)"metadata may not be null");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deregistering RSocket: " + metadata));
        }
        if ((loadBalanced = this.rsockets.get(metadata.getName())) != null) {
            loadBalanced.remove(metadata);
        }
    }

    public LoadBalancedRSocket getRegistered(Metadata metadata) {
        return this.rsockets.get(metadata.getName());
    }

    public Disposable addListener(Consumer<RegisteredEvent> consumer) {
        return this.registeredEvents.subscribe(consumer);
    }

    public static class RegisteredEvent {
        private final Metadata routingMetadata;
        private final RSocket rSocket;

        public RegisteredEvent(Metadata routingMetadata, RSocket rSocket) {
            Assert.notNull((Object)routingMetadata, (String)"routingMetadata may not be null");
            Assert.notNull((Object)rSocket, (String)"RSocket may not be null");
            this.routingMetadata = routingMetadata;
            this.rSocket = rSocket;
        }

        public Metadata getRoutingMetadata() {
            return this.routingMetadata;
        }

        public RSocket getRSocket() {
            return this.rSocket;
        }
    }
}

