/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.registry;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.rsocket.registry.Registry;
import org.springframework.cloud.gateway.rsocket.route.Route;
import org.springframework.cloud.gateway.rsocket.route.Routes;
import org.springframework.cloud.gateway.rsocket.support.Metadata;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RegistryRoutes
implements Routes,
Consumer<Registry.RegisteredEvent> {
    private static final Log log = LogFactory.getLog(RegistryRoutes.class);
    private Map<String, Route> routes = new ConcurrentHashMap<String, Route>();

    @Override
    public Flux<Route> getRoutes() {
        Collection<Route> routeCollection = this.routes.values();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found routes: " + routeCollection));
        }
        return Flux.fromIterable(routeCollection);
    }

    @Override
    public void accept(Registry.RegisteredEvent registeredEvent) {
        Metadata routingMetadata = registeredEvent.getRoutingMetadata();
        String id = this.getId(routingMetadata);
        this.routes.computeIfAbsent(id, key -> this.createRoute(id, routingMetadata));
    }

    private String getId(Metadata routingMetadata) {
        String id = routingMetadata.getName();
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        return id;
    }

    private Route createRoute(String id, Metadata routingMetadata) {
        Route route = Route.builder().id(id).routingMetadata(routingMetadata).predicate(exchange -> {
            Metadata incomingRouting = exchange.getRoutingMetadata();
            boolean matches = incomingRouting.getName().equalsIgnoreCase(routingMetadata.getName());
            return Mono.just((Object)matches);
        }).build();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created Route for registered service " + route));
        }
        return route;
    }
}

