/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.registry;

import org.springframework.cloud.gateway.rsocket.filter.RSocketFilter;
import org.springframework.cloud.gateway.rsocket.registry.Registry;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorExchange;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorFilter;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorFilterChain;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class RegistrySocketAcceptorFilter
implements SocketAcceptorFilter,
Ordered {
    private final Registry registry;

    public RegistrySocketAcceptorFilter(Registry registry) {
        this.registry = registry;
    }

    @Override
    public Mono<RSocketFilter.Success> filter(SocketAcceptorExchange exchange, SocketAcceptorFilterChain chain) {
        if (exchange.getMetadata() != null && StringUtils.hasLength((String)exchange.getMetadata().getName())) {
            this.registry.register(exchange.getMetadata(), exchange.getSendingSocket());
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return -2147482648;
    }
}

