/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.route;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.gateway.rsocket.core.GatewayExchange;
import org.springframework.cloud.gateway.rsocket.core.GatewayFilter;
import org.springframework.cloud.gateway.rsocket.support.AsyncPredicate;
import org.springframework.cloud.gateway.rsocket.support.Metadata;
import org.springframework.core.Ordered;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class Route
implements Ordered {
    private final String id;
    private final Metadata targetMetadata;
    private final int order;
    private final AsyncPredicate<GatewayExchange> predicate;
    private final List<GatewayFilter> gatewayFilters;

    public static Builder builder() {
        return new Builder();
    }

    private Route(String id, Metadata targetMetadata, int order, AsyncPredicate<GatewayExchange> predicate, List<GatewayFilter> gatewayFilters) {
        this.id = id;
        this.targetMetadata = targetMetadata;
        this.order = order;
        this.predicate = predicate;
        this.gatewayFilters = gatewayFilters;
    }

    public String getId() {
        return this.id;
    }

    public Metadata getTargetMetadata() {
        return this.targetMetadata;
    }

    public int getOrder() {
        return this.order;
    }

    public AsyncPredicate<GatewayExchange> getPredicate() {
        return this.predicate;
    }

    public List<GatewayFilter> getFilters() {
        return Collections.unmodifiableList(this.gatewayFilters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route route = (Route)o;
        return Objects.equals(this.id, route.id) && Objects.equals(this.targetMetadata, route.targetMetadata) && Objects.equals(this.order, route.order) && Objects.equals(this.predicate, route.predicate) && Objects.equals(this.gatewayFilters, route.gatewayFilters);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.targetMetadata, this.predicate, this.gatewayFilters);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.id).append("targetMetadata", (Object)this.targetMetadata).append("order", this.order).append("predicate", this.predicate).append("gatewayFilters", this.gatewayFilters).toString();
    }

    public static class Builder {
        protected String id;
        protected Metadata routingMetadata;
        protected int order = 0;
        protected AsyncPredicate<GatewayExchange> predicate;
        protected List<GatewayFilter> gatewayFilters = new ArrayList<GatewayFilter>();

        protected Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public AsyncPredicate<GatewayExchange> getPredicate() {
            return this.predicate;
        }

        public Builder routingMetadata(Metadata routingMetadata) {
            this.routingMetadata = routingMetadata;
            return this;
        }

        public Builder setFilters(List<GatewayFilter> gatewayFilters) {
            this.gatewayFilters = gatewayFilters;
            return this;
        }

        public Builder filter(GatewayFilter gatewayFilter) {
            this.gatewayFilters.add(gatewayFilter);
            return this;
        }

        public Builder filters(Collection<GatewayFilter> gatewayFilters) {
            this.gatewayFilters.addAll(gatewayFilters);
            return this;
        }

        public Builder filters(GatewayFilter ... gatewayFilters) {
            return this.filters(Arrays.asList(gatewayFilters));
        }

        public Builder predicate(AsyncPredicate<GatewayExchange> predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder and(AsyncPredicate<GatewayExchange> predicate) {
            Assert.notNull(this.predicate, (String)"can not call and() on null predicate");
            this.predicate = this.predicate.and(predicate);
            return this;
        }

        public Builder or(AsyncPredicate<GatewayExchange> predicate) {
            Assert.notNull(this.predicate, (String)"can not call or() on null predicate");
            this.predicate = this.predicate.or(predicate);
            return this;
        }

        public Builder negate() {
            Assert.notNull(this.predicate, (String)"can not call negate() on null predicate");
            this.predicate = this.predicate.negate();
            return this;
        }

        public Route build() {
            Assert.notNull((Object)this.id, (String)"id can not be null");
            Assert.notNull((Object)this.routingMetadata, (String)"targetMetadata can not be null");
            Assert.notNull(this.predicate, (String)"predicate can not be null");
            return new Route(this.id, this.routingMetadata, this.order, this.predicate, this.gatewayFilters);
        }
    }
}

