/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.route;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.rsocket.core.GatewayExchange;
import org.springframework.cloud.gateway.rsocket.route.Route;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface Routes {
    public static final Log log = LogFactory.getLog(Routes.class);

    public Flux<Route> getRoutes();

    default public Mono<Route> findRoute(GatewayExchange exchange) {
        return this.getRoutes().concatMap(route -> Mono.just((Object)route).filterWhen(r -> (Publisher)r.getPredicate().apply(exchange)).doOnError(e -> log.error((Object)("Error applying predicate for route: " + route.getId()), e)).onErrorResume(e -> Mono.empty())).next().map(route -> {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Route matched: " + route.getId()));
            }
            return route;
        });
    }
}

