/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.socketacceptor;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.rsocket.ConnectionSetupPayload;
import io.rsocket.RSocket;
import io.rsocket.SocketAcceptor;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.rsocket.autoconfigure.GatewayRSocketProperties;
import org.springframework.cloud.gateway.rsocket.core.GatewayRSocket;
import org.springframework.cloud.gateway.rsocket.metrics.MicrometerResponderRSocket;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorExchange;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorFilter;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorFilterChain;
import org.springframework.cloud.gateway.rsocket.support.Metadata;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class GatewaySocketAcceptor
implements SocketAcceptor {
    private static final Log log = LogFactory.getLog(GatewaySocketAcceptor.class);
    private final SocketAcceptorFilterChain filterChain;
    private final GatewayRSocket.Factory rSocketFactory;
    private final MeterRegistry meterRegistry;
    private final GatewayRSocketProperties properties;

    public GatewaySocketAcceptor(GatewayRSocket.Factory rSocketFactory, List<SocketAcceptorFilter> filters, MeterRegistry meterRegistry, GatewayRSocketProperties properties) {
        this.rSocketFactory = rSocketFactory;
        this.filterChain = new SocketAcceptorFilterChain(filters);
        this.meterRegistry = meterRegistry;
        this.properties = properties;
    }

    public Mono<RSocket> accept(ConnectionSetupPayload setup, RSocket sendingSocket) {
        SocketAcceptorExchange exchange;
        Tags metadataTags;
        if (log.isTraceEnabled()) {
            log.trace((Object)"accept()");
        }
        Tags requesterTags = Tags.of((String[])new String[]{"gateway.id", this.properties.getId(), "type", "requester"});
        if (setup.hasMetadata()) {
            Metadata metadata = Metadata.decodeMetadata(setup.sliceMetadata());
            metadataTags = Tags.of((String)"service.name", (String)metadata.getName()).and("service.id", metadata.get("id"));
            exchange = new SocketAcceptorExchange(setup, this.decorate(sendingSocket, requesterTags.and((Iterable)metadataTags)), metadata);
        } else {
            metadataTags = Tags.of((String)"service.name", (String)"UNKNOWN").and("service.id", "UNKNOWN");
            exchange = new SocketAcceptorExchange(setup, this.decorate(sendingSocket, requesterTags));
        }
        Tags responderTags = Tags.of((String[])new String[]{"gateway.id", this.properties.getId(), "type", "responder"}).and((Iterable)metadataTags);
        return this.filterChain.filter(exchange).log(GatewaySocketAcceptor.class.getName() + ".socket acceptor filter chain", Level.FINEST, new SignalType[0]).map(success -> this.decorate((RSocket)this.rSocketFactory.create(exchange.getMetadata()), responderTags));
    }

    private RSocket decorate(RSocket rSocket, Tags tags) {
        Tag[] tagArray = tags.stream().collect(Collectors.toList()).toArray(new Tag[0]);
        return new MicrometerResponderRSocket(rSocket, this.meterRegistry, tagArray);
    }
}

