/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.socketacceptor;

import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.rsocket.filter.RSocketFilter;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorExchange;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorFilter;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorFilterChain;
import org.springframework.cloud.gateway.rsocket.socketacceptor.SocketAcceptorPredicate;
import org.springframework.cloud.gateway.rsocket.support.AsyncPredicate;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class SocketAcceptorPredicateFilter
implements SocketAcceptorFilter,
Ordered {
    private final AsyncPredicate<SocketAcceptorExchange> predicate;

    public SocketAcceptorPredicateFilter(List<SocketAcceptorPredicate> predicates) {
        Assert.notNull(predicates, (String)"predicates may not be null");
        if (predicates.isEmpty()) {
            this.predicate = exchange -> Mono.just((Object)true);
        } else {
            AsyncPredicate<SocketAcceptorExchange> combined = predicates.get(0);
            for (SocketAcceptorPredicate p : predicates.subList(1, predicates.size())) {
                combined = combined.and(p);
            }
            this.predicate = combined;
        }
    }

    public int getOrder() {
        return -2147473648;
    }

    @Override
    public Mono<RSocketFilter.Success> filter(SocketAcceptorExchange exchange, SocketAcceptorFilterChain chain) {
        return Mono.from((Publisher)((Publisher)this.predicate.apply(exchange))).flatMap(test -> {
            if (test.booleanValue()) {
                return chain.filter(exchange);
            }
            return Mono.empty();
        });
    }
}

