/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.rsocket.support;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.rsocket.util.NumberUtils;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class Metadata {
    public static final String ROUTING_MIME_TYPE = "message/x.rsocket.routing.v0";
    private final String name;
    private final Map<String, String> properties;

    public Metadata(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    public String put(String key, String value) {
        return this.properties.put(key, value);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.name).append("properties", this.properties).toString();
    }

    public static Builder from(String name) {
        return new Builder(name);
    }

    public static ByteBuf encode(Metadata metadata) {
        return Metadata.encode(ByteBufAllocator.DEFAULT, metadata);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, Metadata metadata) {
        return Metadata.encode(allocator, metadata.getName(), metadata.getProperties());
    }

    public static ByteBuf encode(String name, Map<String, String> properties) {
        return Metadata.encode(ByteBufAllocator.DEFAULT, name, properties);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, String name, Map<String, String> properties) {
        Assert.hasText((String)name, (String)"name may not be empty");
        Assert.notNull(properties, (String)"properties may not be null");
        Assert.notNull((Object)allocator, (String)"allocator may not be null");
        ByteBuf byteBuf = allocator.buffer();
        Metadata.encodeString(byteBuf, name);
        properties.entrySet().stream().forEach(entry -> {
            Metadata.encodeString(byteBuf, (String)entry.getKey());
            Metadata.encodeString(byteBuf, (String)entry.getValue());
        });
        return byteBuf;
    }

    private static void encodeString(ByteBuf byteBuf, String s) {
        int length = NumberUtils.requireUnsignedByte((int)ByteBufUtil.utf8Bytes((CharSequence)s));
        byteBuf.writeByte(length);
        ByteBufUtil.reserveAndWriteUtf8((ByteBuf)byteBuf, (CharSequence)s, (int)length);
    }

    public static Metadata decodeMetadata(ByteBuf byteBuf) {
        AtomicInteger offset = new AtomicInteger(0);
        String name = Metadata.decodeString(byteBuf, offset);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        while (offset.get() < byteBuf.readableBytes()) {
            String key = Metadata.decodeString(byteBuf, offset);
            String value = null;
            if (offset.get() < byteBuf.readableBytes()) {
                value = Metadata.decodeString(byteBuf, offset);
            }
            properties.put(key, value);
        }
        return new Metadata(name, properties);
    }

    private static String decodeString(ByteBuf byteBuf, AtomicInteger offset) {
        byte length = byteBuf.getByte(offset.get());
        int index = offset.addAndGet(1);
        String s = byteBuf.toString(index, (int)length, StandardCharsets.UTF_8);
        offset.addAndGet(length);
        return s;
    }

    public boolean matches(Metadata other) {
        if (other == null) {
            return false;
        }
        if (other.getName() == null) {
            return false;
        }
        if (!this.getName().equalsIgnoreCase(other.getName())) {
            return false;
        }
        return Metadata.matches(this.getProperties(), other.getProperties());
    }

    public static boolean matches(Map<String, String> leftMetadata, Map<String, String> rightMetadata) {
        if (leftMetadata == null || rightMetadata == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : leftMetadata.entrySet()) {
            String enrichedValue = rightMetadata.get(entry.getKey());
            if (enrichedValue != null && enrichedValue.equalsIgnoreCase(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private final Metadata metadata;

        public Builder(String name) {
            Assert.hasText((String)name, (String)"Name must not be empty.");
            this.metadata = new Metadata(name, new LinkedHashMap<String, String>());
        }

        public Builder with(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Metadata build() {
            return this.metadata;
        }

        public ByteBuf encode() {
            return Metadata.encode(this.build());
        }
    }
}

