/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.concurrency.limits.reactive;

import com.netflix.concurrency.limits.Limiter;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ConcurrencyLimitsWebFilter
implements WebFilter {
    private final Limiter<ServerWebExchange> limiter;

    public ConcurrencyLimitsWebFilter(Limiter<ServerWebExchange> limiter) {
        this.limiter = limiter;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.limiter.acquire((Object)exchange).map(listener -> chain.filter(exchange).doOnSuccess(v -> listener.onSuccess()).doOnError(throwable -> listener.onIgnore())).orElseGet(() -> {
            exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
            return exchange.getResponse().setComplete();
        });
    }
}

