/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.concurrency.limits.reactive;

import com.netflix.concurrency.limits.Limiter;
import java.util.function.Consumer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.netflix.concurrency.limits.reactive.ConcurrencyLimitsWebFilter;
import org.springframework.cloud.netflix.concurrency.limits.reactive.ServerWebExchangeLimiterBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={WebFilter.class, Mono.class})
public class ReactiveConcurrencyLimitsAutoConfiguration {
    private final ObjectProvider<Consumer<ServerWebExchangeLimiterBuilder>> configurerProvider;

    public ReactiveConcurrencyLimitsAutoConfiguration(ObjectProvider<Consumer<ServerWebExchangeLimiterBuilder>> configurerProvider) {
        this.configurerProvider = configurerProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public Limiter<ServerWebExchange> webfluxLimiter() {
        ServerWebExchangeLimiterBuilder builder = new ServerWebExchangeLimiterBuilder();
        this.configurerProvider.ifAvailable(consumer -> consumer.accept(builder));
        return builder.build();
    }

    @Bean
    public ConcurrencyLimitsWebFilter concurrencyLimitsWebFilter(Limiter<ServerWebExchange> limiter) {
        return new ConcurrencyLimitsWebFilter(limiter);
    }
}

