/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.concurrency.limits.reactive;

import com.netflix.concurrency.limits.limiter.AbstractPartitionedLimiter;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.web.server.ServerWebExchange;

public class ServerWebExchangeLimiterBuilder
extends AbstractPartitionedLimiter.Builder<ServerWebExchangeLimiterBuilder, ServerWebExchange> {
    public ServerWebExchangeLimiterBuilder partitionByHeader(String name) {
        return (ServerWebExchangeLimiterBuilder)this.partitionResolver(exchange -> exchange.getRequest().getHeaders().getFirst(name));
    }

    public ServerWebExchangeLimiterBuilder partitionByAttribute(String name) {
        return (ServerWebExchangeLimiterBuilder)this.partitionResolver(exchange -> (String)exchange.getAttribute(name));
    }

    public ServerWebExchangeLimiterBuilder partitionByParameter(String name) {
        return (ServerWebExchangeLimiterBuilder)this.partitionResolver(exchange -> (String)exchange.getRequest().getQueryParams().getFirst((Object)name));
    }

    public ServerWebExchangeLimiterBuilder partitionByPathInfo(Function<String, String> pathToGroup) {
        return (ServerWebExchangeLimiterBuilder)this.partitionResolver(exchange -> {
            String path = exchange.getRequest().getPath().contextPath().value();
            return Optional.ofNullable(path).map(pathToGroup).orElse(null);
        });
    }

    protected ServerWebExchangeLimiterBuilder self() {
        return this;
    }
}

