/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.concurrency.limits.web;

import com.netflix.concurrency.limits.Limiter;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ConcurrencyLimitsHandlerInterceptor
implements HandlerInterceptor {
    private final Limiter<HttpServletRequest> limiter;

    public ConcurrencyLimitsHandlerInterceptor(Limiter<HttpServletRequest> limiter) {
        this.limiter = limiter;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Optional listener = this.limiter.acquire((Object)request);
        if (listener.isPresent()) {
            request.setAttribute("concurrency_limiter_listener", listener.get());
            return true;
        }
        try {
            response.sendError(HttpStatus.TOO_MANY_REQUESTS.value(), "Concurrency limit exceeded");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Limiter.Listener listener = (Limiter.Listener)request.getAttribute("concurrency_limiter_listener");
        if (listener != null) {
            if (ex != null) {
                listener.onIgnore();
            } else {
                listener.onSuccess();
            }
        }
    }
}

