/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.concurrency.limits.web;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.servlet.ServletLimiterBuilder;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.netflix.concurrency.limits.web.ConcurrencyLimitsHandlerInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={HttpServletRequest.class, HandlerInterceptor.class})
public class MvcConcurrencyLimitsAutoConfiguration
implements WebMvcConfigurer {
    private final ObjectProvider<Consumer<ServletLimiterBuilder>> configurerProvider;

    public MvcConcurrencyLimitsAutoConfiguration(ObjectProvider<Consumer<ServletLimiterBuilder>> configurerProvider) {
        this.configurerProvider = configurerProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public Limiter<HttpServletRequest> servletLimiter() {
        ServletLimiterBuilder builder = new ServletLimiterBuilder();
        this.configurerProvider.ifAvailable(consumer -> consumer.accept(builder));
        return builder.build();
    }

    @Configuration
    protected static class HandlerInterceptorConfiguration
    implements WebMvcConfigurer {
        @Autowired
        private Limiter<HttpServletRequest> limiter;

        protected HandlerInterceptorConfiguration() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)new ConcurrencyLimitsHandlerInterceptor(this.limiter));
        }
    }
}

