/*
 * Decompiled with CFR 0.152.
 */
package com.example.servicebroker;

import org.springframework.cloud.servicebroker.model.catalog.Catalog;
import org.springframework.cloud.servicebroker.model.catalog.Plan;
import org.springframework.cloud.servicebroker.model.catalog.ServiceDefinition;
import org.springframework.cloud.servicebroker.service.CatalogService;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ExampleCatalogService
implements CatalogService {
    public Mono<Catalog> getCatalog() {
        return this.getServiceDefinition("example-service").map(serviceDefinition -> Catalog.builder().serviceDefinitions(new ServiceDefinition[]{serviceDefinition}).build());
    }

    public Mono<ServiceDefinition> getServiceDefinition(String serviceId) {
        ServiceDefinition serviceDefinition = ServiceDefinition.builder().id(serviceId).name("example").description("A simple example").bindable(true).tags(new String[]{"example", "tags"}).plans(new Plan[]{this.getPlan()}).build();
        return Mono.just((Object)serviceDefinition);
    }

    private Plan getPlan() {
        return Plan.builder().id("simple-plan").name("standard").description("A simple plan").free(true).build();
    }
}

