/*
 * Decompiled with CFR 0.152.
 */
package com.example.servicebroker;

import java.util.Map;
import org.springframework.cloud.servicebroker.model.instance.CreateServiceInstanceRequest;
import org.springframework.cloud.servicebroker.model.instance.CreateServiceInstanceResponse;
import org.springframework.cloud.servicebroker.model.instance.DeleteServiceInstanceRequest;
import org.springframework.cloud.servicebroker.model.instance.DeleteServiceInstanceResponse;
import org.springframework.cloud.servicebroker.model.instance.GetLastServiceOperationRequest;
import org.springframework.cloud.servicebroker.model.instance.GetLastServiceOperationResponse;
import org.springframework.cloud.servicebroker.model.instance.GetServiceInstanceRequest;
import org.springframework.cloud.servicebroker.model.instance.GetServiceInstanceResponse;
import org.springframework.cloud.servicebroker.model.instance.OperationState;
import org.springframework.cloud.servicebroker.model.instance.UpdateServiceInstanceRequest;
import org.springframework.cloud.servicebroker.model.instance.UpdateServiceInstanceResponse;
import org.springframework.cloud.servicebroker.service.ServiceInstanceService;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ExampleServiceInstanceService
implements ServiceInstanceService {
    public Mono<CreateServiceInstanceResponse> createServiceInstance(CreateServiceInstanceRequest request) {
        String serviceInstanceId = request.getServiceInstanceId();
        String planId = request.getPlanId();
        Map parameters = request.getParameters();
        String dashboardUrl = new String();
        CreateServiceInstanceResponse response = CreateServiceInstanceResponse.builder().dashboardUrl(dashboardUrl).async(true).build();
        return Mono.just((Object)response);
    }

    public Mono<UpdateServiceInstanceResponse> updateServiceInstance(UpdateServiceInstanceRequest request) {
        String serviceInstanceId = request.getServiceInstanceId();
        String planId = request.getPlanId();
        String previousPlan = request.getPreviousValues().getPlanId();
        Map parameters = request.getParameters();
        UpdateServiceInstanceResponse response = UpdateServiceInstanceResponse.builder().async(true).build();
        return Mono.just((Object)response);
    }

    public Mono<DeleteServiceInstanceResponse> deleteServiceInstance(DeleteServiceInstanceRequest request) {
        String serviceInstanceId = request.getServiceInstanceId();
        String planId = request.getPlanId();
        DeleteServiceInstanceResponse response = DeleteServiceInstanceResponse.builder().async(true).build();
        return Mono.just((Object)response);
    }

    public Mono<GetServiceInstanceResponse> getServiceInstance(GetServiceInstanceRequest request) {
        String serviceInstanceId = request.getServiceInstanceId();
        String dashboardUrl = new String();
        GetServiceInstanceResponse response = GetServiceInstanceResponse.builder().dashboardUrl(dashboardUrl).build();
        return Mono.just((Object)response);
    }

    public Mono<GetLastServiceOperationResponse> getLastOperation(GetLastServiceOperationRequest request) {
        String serviceInstanceId = request.getServiceInstanceId();
        OperationState state = OperationState.SUCCEEDED;
        GetLastServiceOperationResponse response = GetLastServiceOperationResponse.builder().operationState(state).build();
        return Mono.just((Object)response);
    }
}

