/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.actuate;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.IterableAssert;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.actuate.BufferingSpanReporter;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"spring.jackson.serialization.indent_output=true", "management.endpoints.web.exposure.include=*", "spring.jackson.default-property-inclusion=non_null"})
public abstract class TraceSleuthActuatorAutoConfigurationIntegrationTests {
    protected MockMvc mockMvc;
    @Autowired
    WebApplicationContext applicationContext;
    @Autowired
    protected Tracer tracer;
    @Autowired
    protected BufferingSpanReporter bufferingSpanReporter;

    @BeforeEach
    void setup() throws InterruptedException {
        this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.applicationContext).build();
        Span start = this.tracer.nextSpan().name("first").start();
        Thread.sleep(5L);
        Span second = this.tracer.nextSpan().name("second").start();
        Thread.sleep(10L);
        Span third = this.tracer.nextSpan().name("third").start();
        Thread.sleep(15L);
        third.end();
        second.end();
        start.end();
    }

    @Test
    void tracesZipkinSnapshot() throws Exception {
        this.tracesSnapshot(MediaType.APPLICATION_JSON, this.zipkinJsonBody());
    }

    @Test
    void tracesZipkin() throws Exception {
        this.traces(MediaType.APPLICATION_JSON, this.zipkinJsonBody());
    }

    protected void tracesSnapshot(MediaType contentType, ResultMatcher resultMatcher) throws Exception {
        Awaitility.await().untilAsserted(() -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)BDDAssertions.then(this.bufferedSpans()).isNotEmpty();
        });
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/actuator/traces", (Object[])new Object[0]).accept(new MediaType[]{contentType})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(resultMatcher);
        BDDAssertions.then(this.bufferedSpans()).isNotEmpty();
    }

    protected void traces(MediaType acceptType, ResultMatcher resultMatcher) throws Exception {
        Awaitility.await().untilAsserted(() -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)BDDAssertions.then(this.bufferedSpans()).isNotEmpty();
        });
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/actuator/traces", (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{acceptType})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(resultMatcher);
        BDDAssertions.then(this.bufferedSpans()).isEmpty();
    }

    protected ResultMatcher zipkinJsonBody() {
        return MockMvcResultMatchers.content().string(Matchers.allOf((Matcher)Matchers.containsString((String)"\"name\":\"first\""), (Matcher)Matchers.containsString((String)"\"name\":\"second\""), (Matcher)Matchers.containsString((String)"\"name\":\"third\"")));
    }

    protected ConcurrentLinkedQueue<FinishedSpan> bufferedSpans() {
        return this.bufferingSpanReporter.spans;
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    static class TestConfig {
        TestConfig() {
        }
    }
}

