/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanName;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;

@ExtendWith(value={MockitoExtension.class})
public abstract class TraceCallableTests
implements TestTracingAwareSupplier {
    ExecutorService executor = Executors.newSingleThreadExecutor();

    @AfterEach
    public void clean() {
        this.executor.shutdown();
    }

    @Test
    public void should_not_see_same_trace_id_in_successive_tasks() throws Exception {
        Span firstSpan = this.givenCallableGetsSubmitted(this.thatRetrievesTraceFromThreadLocal());
        Span secondSpan = this.whenCallableGetsSubmitted(this.thatRetrievesTraceFromThreadLocal());
        BDDAssertions.then((String)secondSpan.context().traceId()).isNotEqualTo((Object)firstSpan.context().traceId());
    }

    @Test
    public void should_remove_span_from_thread_local_after_finishing_work() throws Exception {
        this.givenCallableGetsSubmitted(this.thatRetrievesTraceFromThreadLocal());
        Span secondSpan = this.whenNonTraceableCallableGetsSubmitted(this.thatRetrievesTraceFromThreadLocal());
        BDDAssertions.then((Object)secondSpan).isNull();
    }

    @Test
    public void should_remove_parent_span_from_thread_local_after_finishing_work() throws Exception {
        Span parent = this.tracerTest().tracing().tracer().nextSpan().name("http:parent");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(parent);){
            Span child = this.givenCallableGetsSubmitted(this.thatRetrievesTraceFromThreadLocal());
            ((ObjectAssert)BDDAssertions.then((Object)parent).as("parent", new Object[0])).isNotNull();
            BDDAssertions.then((String)child.context().parentId()).isEqualTo(parent.context().spanId());
        }
        BDDAssertions.then((Object)this.tracerTest().tracing().tracer().currentSpan()).isNull();
        Span secondSpan = this.whenNonTraceableCallableGetsSubmitted(this.thatRetrievesTraceFromThreadLocal());
        BDDAssertions.then((Object)secondSpan).isNull();
    }

    @Test
    public void should_take_name_of_span_from_span_name_annotation() throws Exception {
        this.whenATraceKeepingCallableGetsSubmitted();
        BDDAssertions.then(this.tracerTest().handler().reportedSpans()).hasSize(1);
        BDDAssertions.then((String)this.tracerTest().handler().reportedSpans().get(0).getName()).isEqualTo("some-callable-name-from-annotation");
    }

    @Test
    public void should_take_name_of_span_from_to_string_if_span_name_annotation_is_missing() throws Exception {
        this.whenCallableGetsSubmitted(this.thatRetrievesTraceFromThreadLocal());
        BDDAssertions.then(this.tracerTest().handler().reportedSpans()).hasSize(1);
        BDDAssertions.then((String)this.tracerTest().handler().reportedSpans().get(0).getName()).isEqualTo("some-callable-name-from-to-string");
    }

    private Callable<Span> thatRetrievesTraceFromThreadLocal() {
        return new Callable<Span>(){

            @Override
            public Span call() throws Exception {
                return TraceCallableTests.this.tracerTest().tracing().tracer().currentSpan();
            }

            public String toString() {
                return "some-callable-name-from-to-string";
            }
        };
    }

    private Span givenCallableGetsSubmitted(Callable<Span> callable) throws InterruptedException, ExecutionException {
        return this.whenCallableGetsSubmitted(callable);
    }

    private Span whenCallableGetsSubmitted(Callable<Span> callable) throws InterruptedException, ExecutionException {
        return (Span)this.executor.submit(new TraceCallable(this.tracerTest().tracing().tracer(), (SpanNamer)new DefaultSpanNamer(), callable)).get();
    }

    private Span whenATraceKeepingCallableGetsSubmitted() throws InterruptedException, ExecutionException {
        return (Span)this.executor.submit(new TraceCallable(this.tracerTest().tracing().tracer(), (SpanNamer)new DefaultSpanNamer(), (Callable)new TraceKeepingCallable(this.tracerTest().tracing().tracer()))).get();
    }

    private Span whenNonTraceableCallableGetsSubmitted(Callable<Span> callable) throws InterruptedException, ExecutionException {
        return this.executor.submit(callable).get();
    }

    @SpanName(value="some-callable-name-from-annotation")
    static class TraceKeepingCallable
    implements Callable<Span> {
        public Span span;
        private final Tracer tracer;

        TraceKeepingCallable(Tracer tracer) {
            this.tracer = tracer;
        }

        @Override
        public Span call() throws Exception {
            this.span = this.tracer.currentSpan();
            return this.span;
        }
    }
}

