/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.List;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.messaging.TracingChannelInterceptor;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.AbstractSubscribableChannel;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;

@ContextConfiguration(classes={TestConfig.class})
public abstract class TraceWebSocketAutoConfigurationTests {
    @Autowired
    DelegatingWebSocketMessageBrokerConfiguration delegatingWebSocketMessageBrokerConfiguration;

    @Test
    public void should_register_interceptors_for_all_channels() {
        AbstractSubscribableChannel inboundChannel = this.delegatingWebSocketMessageBrokerConfiguration.clientInboundChannel(this.delegatingWebSocketMessageBrokerConfiguration.clientInboundChannelExecutor());
        BDDAssertions.then((List)inboundChannel.getInterceptors()).hasAtLeastOneElementOfType(TracingChannelInterceptor.class);
        AbstractSubscribableChannel outboundChannel = this.delegatingWebSocketMessageBrokerConfiguration.clientOutboundChannel(this.delegatingWebSocketMessageBrokerConfiguration.clientOutboundChannelExecutor());
        BDDAssertions.then((List)outboundChannel.getInterceptors()).hasAtLeastOneElementOfType(TracingChannelInterceptor.class);
        BDDAssertions.then((List)this.delegatingWebSocketMessageBrokerConfiguration.brokerChannel(inboundChannel, outboundChannel, this.delegatingWebSocketMessageBrokerConfiguration.brokerChannelExecutor(inboundChannel, outboundChannel)).getInterceptors()).hasAtLeastOneElementOfType(TracingChannelInterceptor.class);
    }

    @EnableAutoConfiguration
    @Configuration(proxyBeanMethods=false)
    @EnableWebSocketMessageBroker
    public static class TestConfig
    extends AbstractWebSocketMessageBrokerConfigurer {
        public void configureMessageBroker(MessageBrokerRegistry config) {
            config.enableSimpleBroker(new String[]{"/topic"});
            config.setApplicationDestinationPrefixes(new String[]{"/app"});
        }

        public void registerStompEndpoints(StompEndpointRegistry registry) {
            registry.addEndpoint(new String[]{"/hello"}).withSockJS();
        }
    }
}

