/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.r2dbc;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.instrument.r2dbc.ReactiveNewTransactionService;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DataAccessException;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"spring.application.name=MyApplication"})
public abstract class R2dbcIntegrationTests {
    @Autowired
    TestSpanHandler spans;

    @Test
    public void should_pass_tracing_information_when_using_r2dbc() {
        Set traceIds = this.spans.reportedSpans().stream().map(FinishedSpan::getTraceId).collect(Collectors.toSet());
        ((IterableAssert)BDDAssertions.then(traceIds).as("There's one traceid", new Object[0])).hasSize(1);
        Set spanIds = this.spans.reportedSpans().stream().map(FinishedSpan::getSpanId).collect(Collectors.toSet());
        ((IterableAssert)BDDAssertions.then(spanIds).as("There are 11 spans", new Object[0])).hasSize(11);
        List spanNames = this.spans.reportedSpans().stream().map(FinishedSpan::getName).collect(Collectors.toList());
        List remoteServiceNames = this.spans.reportedSpans().stream().map(FinishedSpan::getRemoteServiceName).collect(Collectors.toList());
        BDDAssertions.then(spanNames.stream().filter("tx"::equalsIgnoreCase).collect(Collectors.toList())).hasSize(2);
        BDDAssertions.then(remoteServiceNames.stream().filter("h2"::equalsIgnoreCase).collect(Collectors.toList())).hasSize(9);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @ComponentScan
    public static class TestConfig {
        private static final Logger log = LoggerFactory.getLogger(TestConfig.class);

        @Bean
        public CommandLineRunner demo(ReactiveNewTransactionService reactiveNewTransactionService) {
            return args -> {
                try {
                    reactiveNewTransactionService.newTransaction().block(Duration.ofSeconds(50L));
                }
                catch (DataAccessException e) {
                    log.info("Expected to throw an exception so that we see if rollback works", (Throwable)e);
                }
            };
        }
    }
}

