/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.task;

import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"spring.application.name=MyApplication", "spring.sleuth.tx.enabled=false"})
public abstract class SpringCloudTaskIntegrationTests {
    @Autowired
    TestSpanHandler spans;

    @Test
    public void should_pass_tracing_information_when_using_spring_cloud_task() {
        Set traceIds = this.spans.reportedSpans().stream().map(FinishedSpan::getTraceId).collect(Collectors.toSet());
        ((IterableAssert)BDDAssertions.then(traceIds).as("There's one traceid", new Object[0])).hasSize(1);
        Set spanIds = this.spans.reportedSpans().stream().map(FinishedSpan::getSpanId).collect(Collectors.toSet());
        ((IterableAssert)BDDAssertions.then(spanIds).as("There are 3 spans", new Object[0])).hasSize(3);
        Iterator<FinishedSpan> spanIterator = this.spans.reportedSpans().iterator();
        FinishedSpan first = spanIterator.next();
        FinishedSpan second = spanIterator.next();
        FinishedSpan third = spanIterator.next();
        BDDAssertions.then((String)first.getName()).isEqualTo("myApplicationRunner");
        BDDAssertions.then((String)second.getName()).isEqualTo("myCommandLineRunner");
        BDDAssertions.then((String)third.getName()).isEqualTo("MyApplication");
    }

    static class MyApplicationRunner
    implements ApplicationRunner {
        private static final Log log = LogFactory.getLog(MyApplicationRunner.class);

        MyApplicationRunner() {
        }

        public void run(ApplicationArguments args) throws Exception {
            log.info((Object)"Ran MyApplicationRunner");
        }
    }

    static class MyCommandLineRunner
    implements CommandLineRunner {
        private static final Log log = LogFactory.getLog(MyCommandLineRunner.class);

        MyCommandLineRunner() {
        }

        public void run(String ... args) throws Exception {
            log.info((Object)"Ran MyCommandLineRunner");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @EnableTask
    public static class TestConfig {
        @Bean
        MyCommandLineRunner myCommandLineRunner() {
            return new MyCommandLineRunner();
        }

        @Bean
        MyApplicationRunner myApplicationRunner() {
            return new MyApplicationRunner();
        }
    }
}

