/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.kotlin;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.assertj.core.api.BDDAssertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.kotlin.WebController;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.web.client.RestTemplate;

@ContextConfiguration(classes={ControllerTestConfig.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/springframework/cloud/sleuth/kotlin/SleuthCoroutinesApplicationTests;", "", "()V", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "getRestTemplate", "()Lorg/springframework/web/client/RestTemplate;", "setRestTemplate", "(Lorg/springframework/web/client/RestTemplate;)V", "serverPort", "", "getServerPort", "()I", "setServerPort", "(I)V", "tracer", "Lorg/springframework/cloud/sleuth/Tracer;", "getTracer", "()Lorg/springframework/cloud/sleuth/Tracer;", "setTracer", "(Lorg/springframework/cloud/sleuth/Tracer;)V", "webController", "Lorg/springframework/cloud/sleuth/kotlin/WebController;", "getWebController", "()Lorg/springframework/cloud/sleuth/kotlin/WebController;", "setWebController", "(Lorg/springframework/cloud/sleuth/kotlin/WebController;)V", "applicationUrl", "", "should_pass_tracing_context_within_coroutines", "", "ControllerTestConfig", "spring-cloud-sleuth-tests-common"})
public abstract class SleuthCoroutinesApplicationTests {
    @LocalServerPort
    private int serverPort;
    @Autowired
    public Tracer tracer;
    @Autowired
    public WebController webController;
    @Autowired
    public RestTemplate restTemplate;

    public final int getServerPort() {
        return this.serverPort;
    }

    public final void setServerPort(int n) {
        this.serverPort = n;
    }

    @NotNull
    public final Tracer getTracer() {
        Tracer tracer = this.tracer;
        if (tracer != null) {
            return tracer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tracer");
        throw null;
    }

    public final void setTracer(@NotNull Tracer tracer) {
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"<set-?>");
        this.tracer = tracer;
    }

    @NotNull
    public final WebController getWebController() {
        WebController webController = this.webController;
        if (webController != null) {
            return webController;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"webController");
        throw null;
    }

    public final void setWebController(@NotNull WebController webController) {
        Intrinsics.checkNotNullParameter((Object)webController, (String)"<set-?>");
        this.webController = webController;
    }

    @NotNull
    public final RestTemplate getRestTemplate() {
        RestTemplate restTemplate = this.restTemplate;
        if (restTemplate != null) {
            return restTemplate;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"restTemplate");
        throw null;
    }

    public final void setRestTemplate(@NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"<set-?>");
        this.restTemplate = restTemplate;
    }

    @Test
    public final void should_pass_tracing_context_within_coroutines() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SleuthCoroutinesApplicationTests this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Span nextSpan = this.this$0.getTracer().nextSpan();
                        String traceId = nextSpan.context().traceId();
                        Closeable closeable = (Closeable)this.this$0.getTracer().withSpan(nextSpan.start());
                        SleuthCoroutinesApplicationTests sleuthCoroutinesApplicationTests = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        Throwable throwable = null;
                        try {
                            TraceContext traceContext;
                            Tracer.SpanInScope spanInScope = (Tracer.SpanInScope)closeable;
                            boolean bl3 = false;
                            String response = (String)sleuthCoroutinesApplicationTests.getRestTemplate().getForObject(SleuthCoroutinesApplicationTests.access$applicationUrl(sleuthCoroutinesApplicationTests), String.class, new Object[0]);
                            BDDAssertions.then((Object)sleuthCoroutinesApplicationTests.getWebController().getSpanInController()).isNotNull();
                            Span span = sleuthCoroutinesApplicationTests.getWebController().getSpanInController();
                            BDDAssertions.then(span == null ? null : ((traceContext = span.context()) == null ? null : traceContext.traceId())).isEqualTo(traceId);
                            BDDAssertions.then((Object)sleuthCoroutinesApplicationTests.getWebController().getSpanInGlobalScopeLaunch()).isNotNull();
                            span = sleuthCoroutinesApplicationTests.getWebController().getSpanInGlobalScopeLaunch();
                            BDDAssertions.then(span == null ? null : ((traceContext = span.context()) == null ? null : traceContext.traceId())).isEqualTo(traceId);
                            BDDAssertions.then((Object)sleuthCoroutinesApplicationTests.getWebController().getSpanInGlobalScopeAsync()).isNotNull();
                            span = sleuthCoroutinesApplicationTests.getWebController().getSpanInGlobalScopeAsync();
                            BDDAssertions.then(span == null ? null : ((traceContext = span.context()) == null ? null : traceContext.traceId())).isEqualTo(traceId);
                            BDDAssertions.then((String)response).isEqualTo(traceId);
                            spanInScope = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final String applicationUrl() {
        return "http://localhost:" + this.serverPort + "/hello";
    }

    public static final /* synthetic */ String access$applicationUrl(SleuthCoroutinesApplicationTests $this) {
        return $this.applicationUrl();
    }

    @TestConfiguration
    @EnableAutoConfiguration
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Lorg/springframework/cloud/sleuth/kotlin/SleuthCoroutinesApplicationTests$ControllerTestConfig;", "", "()V", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "webController", "Lorg/springframework/cloud/sleuth/kotlin/WebController;", "tracer", "Lorg/springframework/cloud/sleuth/Tracer;", "spring-cloud-sleuth-tests-common"})
    public static class ControllerTestConfig {
        @Bean
        @NotNull
        public RestTemplate restTemplate() {
            return new RestTemplate();
        }

        @Bean
        @NotNull
        public WebController webController(@NotNull Tracer tracer) {
            Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
            return new WebController(tracer);
        }
    }
}

