/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.BDDAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@ContextConfiguration(classes={Config.class})
@TestPropertySource(properties={"spring.zipkin.baseUrl=https://zipkin/", "spring.zipkin.sender.type=web"})
public abstract class ZipkinDiscoveryClientTests {
    @Autowired
    MockWebServer mockWebServer;
    @Autowired
    Tracer tracer;

    @Test
    public void shouldUseDiscoveryClientToFindZipkinUrlIfPresent() throws Exception {
        Span span = this.tracer.nextSpan().name("foo").start();
        span.end();
        Awaitility.await().untilAsserted(() -> BDDAssertions.then((int)this.mockWebServer.getRequestCount()).isGreaterThan(0));
    }

    @Configuration(proxyBeanMethods=false)
    static class Config {
        Config() {
        }

        @Bean(initMethod="start", destroyMethod="close")
        MockWebServer mockWebServer() {
            return new MockWebServer();
        }

        @Bean
        LoadBalancerClient loadBalancerClient(final MockWebServer mockWebServer) {
            return new LoadBalancerClient(){

                public <T> T execute(String serviceId, LoadBalancerRequest<T> request) throws IOException {
                    return null;
                }

                public <T> T execute(String serviceId, ServiceInstance serviceInstance, LoadBalancerRequest<T> request) throws IOException {
                    return null;
                }

                public URI reconstructURI(ServiceInstance instance, URI original) {
                    return null;
                }

                public ServiceInstance choose(String serviceId) {
                    return this.instance();
                }

                private ServiceInstance instance() {
                    return new ServiceInstance(){

                        public String getServiceId() {
                            return "zipkin";
                        }

                        public String getHost() {
                            return "localhost";
                        }

                        public int getPort() {
                            return mockWebServer.url("/").port();
                        }

                        public boolean isSecure() {
                            return false;
                        }

                        public URI getUri() {
                            return mockWebServer.url("/").uri();
                        }

                        public Map<String, String> getMetadata() {
                            return null;
                        }
                    };
                }

                public <T> ServiceInstance choose(String serviceId, Request<T> request) {
                    return this.instance();
                }
            };
        }
    }
}

