/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.analytics.metrics.FieldValueCounterRepository;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.dataflow.registry.AppRegistry;
import org.springframework.cloud.dataflow.server.local.TestUtils;
import org.springframework.cloud.dataflow.server.local.dataflowapp.LocalTestDataFlowServer;
import org.springframework.cloud.dataflow.server.local.nodataflowapp.LocalTestNoDataFlowServer;
import org.springframework.cloud.dataflow.server.repository.DeploymentIdRepository;
import org.springframework.cloud.dataflow.server.repository.StreamDefinitionRepository;
import org.springframework.cloud.dataflow.server.repository.TaskDefinitionRepository;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.cloud.deployer.resource.support.LRUCleaningResourceLoader;
import org.springframework.cloud.deployer.spi.local.LocalAppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalTaskLauncher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.SocketUtils;

public class LocalConfigurationTests {
    private static final String APP_DEPLOYER_BEAN_NAME = "appDeployer";
    private static final String TASK_LAUNCHER_BEAN_NAME = "taskLauncher";
    private ConfigurableApplicationContext context;

    @After
    public void tearDown() {
        this.context.close();
    }

    @Test
    public void testConfig() {
        SpringApplication app = new SpringApplication(new Object[]{LocalTestDataFlowServer.class});
        int randomPort = SocketUtils.findAvailableTcpPort();
        String dataSourceUrl = String.format("jdbc:h2:tcp://localhost:%s/mem:dataflow", randomPort);
        this.context = app.run(new String[]{"--server.port=0", "--spring.datasource.url=" + dataSourceUrl});
        Assert.assertThat((Object)this.context.containsBean(APP_DEPLOYER_BEAN_NAME), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.context.getBean(APP_DEPLOYER_BEAN_NAME), (Matcher)Matchers.instanceOf(LocalAppDeployer.class));
        Assert.assertThat((Object)this.context.containsBean(TASK_LAUNCHER_BEAN_NAME), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.context.getBean(TASK_LAUNCHER_BEAN_NAME), (Matcher)Matchers.instanceOf(LocalTaskLauncher.class));
        Assert.assertNotNull((Object)this.context.getBean(AppRegistry.class));
    }

    @Test
    public void testLocalAutoConfigApplied() throws Exception {
        SpringApplication app = new SpringApplication(new Object[]{LocalTestDataFlowServer.class});
        this.context = app.run(new String[]{"--server.port=0"});
        LRUCleaningResourceLoader lruCleaningResourceLoader = (LRUCleaningResourceLoader)this.context.getBean(LRUCleaningResourceLoader.class);
        DelegatingResourceLoader delegatingResourceLoader = (DelegatingResourceLoader)TestUtils.readField("delegate", lruCleaningResourceLoader);
        Map loaders = (Map)TestUtils.readField("loaders", delegatingResourceLoader);
        Assert.assertThat((Object)loaders.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(loaders.get("maven"), (Matcher)Matchers.notNullValue());
        Assert.assertThat(loaders.get("docker"), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testConfigWithStreamsDisabled() {
        SpringApplication app = new SpringApplication(new Object[]{LocalTestDataFlowServer.class});
        this.context = app.run(new String[]{"--server.port=0", "--spring.cloud.dataflow.features.streams-enabled=false"});
        Assert.assertNotNull((Object)this.context.getBean(TaskDefinitionRepository.class));
        Assert.assertNotNull((Object)this.context.getBean(DeploymentIdRepository.class));
        Assert.assertNotNull((Object)this.context.getBean(FieldValueCounterRepository.class));
        try {
            this.context.getBean(StreamDefinitionRepository.class);
            Assert.fail((String)"Stream features should have been disabled.");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    @Test
    public void testConfigWithTasksDisabled() {
        SpringApplication app = new SpringApplication(new Object[]{LocalTestDataFlowServer.class});
        this.context = app.run(new String[]{"--server.port=0", "--spring.cloud.dataflow.features.tasks-enabled=false"});
        Assert.assertNotNull((Object)this.context.getBean(StreamDefinitionRepository.class));
        Assert.assertNotNull((Object)this.context.getBean(DeploymentIdRepository.class));
        Assert.assertNotNull((Object)this.context.getBean(FieldValueCounterRepository.class));
        try {
            this.context.getBean(TaskDefinitionRepository.class);
            Assert.fail((String)"Task features should have been disabled.");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    @Test
    public void testConfigWithAnalyticsDisabled() {
        SpringApplication app = new SpringApplication(new Object[]{LocalTestDataFlowServer.class});
        this.context = app.run(new String[]{"--server.port=0", "--spring.cloud.dataflow.features.analytics-enabled=false"});
        Assert.assertNotNull((Object)this.context.getBean(StreamDefinitionRepository.class));
        Assert.assertNotNull((Object)this.context.getBean(TaskDefinitionRepository.class));
        Assert.assertNotNull((Object)this.context.getBean(DeploymentIdRepository.class));
        try {
            this.context.getBean(FieldValueCounterRepository.class);
            Assert.fail((String)"Task features should have been disabled.");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    @Test
    public void testNoDataflowConfig() {
        SpringApplication app = new SpringApplication(new Object[]{LocalTestNoDataFlowServer.class});
        this.context = app.run(new String[]{"--server.port=0", "--spring.jpa.database=H2"});
        Assert.assertThat((Object)this.context.containsBean(APP_DEPLOYER_BEAN_NAME), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.context.containsBean(TASK_LAUNCHER_BEAN_NAME), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.context.containsBean("appRegistry"), (Matcher)Matchers.is((Object)false));
    }
}

