/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local;

import java.util.Collection;
import javax.servlet.Filter;
import org.junit.rules.ExternalResource;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.dataflow.server.local.dataflowapp.LocalTestDataFlowServer;
import org.springframework.context.ApplicationContext;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public class LocalDataflowResource
extends ExternalResource {
    final boolean streamsEnabled;
    final boolean tasksEnabled;
    final boolean metricsEnabled;
    private String originalConfigLocation = null;
    private SpringApplication app;
    private MockMvc mockMvc;
    private String dataflowPort;
    private String configurationLocation;
    private WebApplicationContext configurableApplicationContext;

    public LocalDataflowResource(String configurationLocation) {
        this.configurationLocation = configurationLocation;
        this.streamsEnabled = true;
        this.tasksEnabled = true;
        this.metricsEnabled = true;
    }

    public LocalDataflowResource(String configurationLocation, boolean streamsEnabled, boolean tasksEnabled) {
        this.configurationLocation = configurationLocation;
        this.streamsEnabled = streamsEnabled;
        this.tasksEnabled = tasksEnabled;
        this.metricsEnabled = true;
    }

    public LocalDataflowResource(String configurationLocation, boolean streamsEnabled, boolean tasksEnabled, boolean metricsEnabled) {
        this.configurationLocation = configurationLocation;
        this.streamsEnabled = streamsEnabled;
        this.tasksEnabled = tasksEnabled;
        this.metricsEnabled = metricsEnabled;
    }

    protected void before() throws Throwable {
        this.originalConfigLocation = System.getProperty("spring.config.location");
        if (!StringUtils.isEmpty((Object)this.configurationLocation)) {
            System.setProperty("spring.config.location", this.configurationLocation);
        }
        this.app = new SpringApplication(new Object[]{LocalTestDataFlowServer.class});
        this.configurableApplicationContext = (WebApplicationContext)this.app.run(new String[]{"--server.port=0", "--spring.cloud.dataflow.features.streams-enabled=" + this.streamsEnabled, "--spring.cloud.dataflow.features.tasks-enabled=" + this.tasksEnabled, "--spring.cloud.dataflow.features.analytics-enabled=" + this.metricsEnabled});
        Collection filters = this.configurableApplicationContext.getBeansOfType(Filter.class).values();
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.configurableApplicationContext).addFilters(filters.toArray(new Filter[filters.size()]))).build();
        this.dataflowPort = this.configurableApplicationContext.getEnvironment().resolvePlaceholders("${server.port}");
    }

    protected void after() {
        SpringApplication.exit((ApplicationContext)this.configurableApplicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        if (this.originalConfigLocation != null) {
            System.setProperty("spring.config.location", this.originalConfigLocation);
        } else {
            System.clearProperty("spring.config.location");
        }
    }

    public MockMvc getMockMvc() {
        return this.mockMvc;
    }

    public String getDataflowPort() {
        return this.dataflowPort;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this.configurableApplicationContext;
    }
}

