/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.springframework.util.ReflectionUtils;

public class TestUtils {
    public static <T> T readField(String name, Object target) throws Exception {
        Field field = null;
        Class<?> clazz = target.getClass();
        do {
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        } while (field == null && !clazz.equals(Object.class));
        if (field == null) {
            throw new IllegalArgumentException("Cannot find field '" + name + "' in the class hierarchy of " + target.getClass());
        }
        field.setAccessible(true);
        return (T)field.get(target);
    }

    public static <T> T callMethod(String name, Object target) throws Exception {
        Class<?> clazz = target.getClass();
        Method method = ReflectionUtils.findMethod(clazz, (String)name);
        if (method == null) {
            throw new IllegalArgumentException("Cannot find method '" + method + "' in the class hierarchy of " + target.getClass());
        }
        method.setAccessible(true);
        return (T)ReflectionUtils.invokeMethod((Method)method, (Object)target);
    }

    public static void setField(String name, Object target, Object value) throws Exception {
        Field field = null;
        Class<?> clazz = target.getClass();
        do {
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        } while (field == null && !clazz.equals(Object.class));
        if (field == null) {
            throw new IllegalArgumentException("Cannot find field '" + name + "' in the class hierarchy of " + target.getClass());
        }
        field.setAccessible(true);
        field.set(target, value);
    }

    public static <T> T callMethod(String name, Object target, Object[] args, Class<?>[] argsTypes) throws Exception {
        Class<?> clazz = target.getClass();
        Method method = ReflectionUtils.findMethod(clazz, (String)name, (Class[])argsTypes);
        if (method == null) {
            throw new IllegalArgumentException("Cannot find method '" + method + "' in the class hierarchy of " + target.getClass());
        }
        method.setAccessible(true);
        return (T)ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])args);
    }

    public static Map<String, String> toImmutableMap(String ... entries) {
        if (entries.length % 2 == 1) {
            throw new IllegalArgumentException("Entries should contain even number of values");
        }
        return Collections.unmodifiableMap(IntStream.range(0, entries.length / 2).map(i -> i * 2).collect(HashMap::new, (m, i) -> m.put(entries[i], entries[i + 1]), Map::putAll));
    }
}

