/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.dataflow.server.local.metrics.FakeMetricsCollector;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.SocketUtils;

public class FakeMetricsCollectorResource
extends ExternalResource {
    private final Log LOGGER = LogFactory.getLog(FakeMetricsCollectorResource.class);
    private String originalServerPort;
    private int serverPort;
    private static final String FAKE_METRICS_COLLECTOR_PORT_PROPERTY = "fakeMetricsCollector.port";
    private ConfigurableApplicationContext application;

    protected void before() throws Throwable {
        this.originalServerPort = System.getProperty(FAKE_METRICS_COLLECTOR_PORT_PROPERTY);
        this.serverPort = SocketUtils.findAvailableTcpPort();
        this.LOGGER.info((Object)("Setting Fake Metrics Collector port to " + this.serverPort));
        System.setProperty(FAKE_METRICS_COLLECTOR_PORT_PROPERTY, String.valueOf(this.serverPort));
        this.application = new SpringApplicationBuilder(new Object[]{FakeMetricsCollector.class}).properties(new String[]{"logging.level.org.springframework.boot.autoconfigure.logging=debug"}).build().run(new String[]{"--spring.config.location=classpath:/org/springframework/cloud/dataflow/server/local/metrics/fakeMetricsCollectorConfig.yml"});
    }

    protected void after() {
        try {
            this.application.stop();
        }
        finally {
            if (this.originalServerPort != null) {
                System.setProperty(FAKE_METRICS_COLLECTOR_PORT_PROPERTY, this.originalServerPort);
            } else {
                System.clearProperty(FAKE_METRICS_COLLECTOR_PORT_PROPERTY);
            }
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }
}

