/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local.security;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.referral.ReferralInterceptor;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public class ApacheDSContainerWithSecurity
implements InitializingBean,
DisposableBean,
Lifecycle,
ApplicationContextAware {
    final DefaultDirectoryService service;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String ldifResources;
    private final JdbmPartition partition;
    private final String root;
    LdapServer server;
    private ApplicationContext ctxt;
    private File workingDir;
    private boolean running;
    private int port = 53389;
    private boolean enabledLdapOverSsl;
    private File keyStoreFile;
    private String keyStorePassword;

    public ApacheDSContainerWithSecurity(String root, String ldifs) throws Exception {
        this.ldifResources = ldifs;
        this.service = new DefaultDirectoryService();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new NormalizationInterceptor());
        list.add(new AuthenticationInterceptor());
        list.add(new ReferralInterceptor());
        list.add(new ExceptionInterceptor());
        list.add(new OperationalAttributeInterceptor());
        list.add(new SubentryInterceptor());
        this.service.setInterceptors(list);
        this.partition = new JdbmPartition();
        this.partition.setId("rootPartition");
        this.partition.setSuffix(root);
        this.root = root;
        this.service.addPartition((Partition)this.partition);
        this.service.setExitVmOnShutdown(false);
        this.service.setShutdownHookEnabled(false);
        this.service.getChangeLog().setEnabled(false);
        this.service.setDenormalizeOpAttrsEnabled(true);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.enabledLdapOverSsl && this.keyStoreFile == null) {
            throw new IllegalArgumentException("When LdapOverSsl is enabled, the keyStoreFile property must be set.");
        }
        if (this.workingDir == null) {
            String apacheWorkDir = System.getProperty("apacheDSWorkDir");
            if (apacheWorkDir == null) {
                apacheWorkDir = this.createTempDirectory("apacheds-spring-security-");
            }
            this.setWorkingDirectory(new File(apacheWorkDir));
        }
        this.server = new LdapServer();
        TcpTransport transport = new TcpTransport(this.port);
        if (this.enabledLdapOverSsl) {
            transport.setEnableSSL(true);
            this.server.setKeystoreFile(this.keyStoreFile.getAbsolutePath());
            this.server.setCertificatePassword(this.keyStorePassword);
        }
        this.server.setTransports(new Transport[]{transport});
        this.server.setDirectoryService((DirectoryService)this.service);
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctxt = applicationContext;
    }

    public void setWorkingDirectory(File workingDir) {
        Assert.notNull((Object)workingDir, (String)"Working Directory can not be null");
        this.logger.info((Object)("Setting working directory for LDAP_PROVIDER: " + workingDir.getAbsolutePath()));
        if (workingDir.exists()) {
            throw new IllegalArgumentException("The specified working directory '" + workingDir.getAbsolutePath() + "' already exists. Another directory service instance may be using it or it may be from a  previous unclean shutdown. Please confirm and delete it or configure a different working directory");
        }
        this.workingDir = workingDir;
        this.service.setWorkingDirectory(workingDir);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setKeyStoreFile(File keyStoreFile) {
        Assert.isTrue((boolean)keyStoreFile.exists(), (String)"The keyStoreFile does not exist.");
        Assert.isTrue((boolean)keyStoreFile.isFile(), (String)"The keyStoreFile must be a file.");
        this.keyStoreFile = keyStoreFile;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setEnabledLdapOverSsl(boolean enabledLdapOverSsl) {
        this.enabledLdapOverSsl = enabledLdapOverSsl;
    }

    public DefaultDirectoryService getService() {
        return this.service;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        if (this.service.isStarted()) {
            throw new IllegalStateException("DirectoryService is already running.");
        }
        this.logger.info((Object)"Starting directory server...");
        try {
            this.service.startup();
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Server startup failed", e);
        }
        try {
            this.service.getAdminSession().lookup(this.partition.getSuffixDn());
        }
        catch (LdapNameNotFoundException e) {
            try {
                LdapDN dn = new LdapDN(this.root);
                Assert.isTrue((boolean)this.root.startsWith("dc="), (String)"root must start with 'dc='");
                String dc = this.root.substring(3, this.root.indexOf(44));
                ServerEntry entry = this.service.newEntry(dn);
                entry.add("objectClass", new String[]{"top", "domain", "extensibleObject"});
                entry.add("dc", new String[]{dc});
                this.service.getAdminSession().add(entry);
            }
            catch (Exception e1) {
                this.logger.error((Object)"Failed to create dc entry", (Throwable)e1);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Lookup failed", (Throwable)e);
        }
        this.running = true;
        try {
            this.importLdifs();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to import LDIF file(s)", e);
        }
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.logger.info((Object)"Shutting down directory server ...");
        try {
            this.server.stop();
            this.service.shutdown();
        }
        catch (Exception e) {
            this.logger.error((Object)"Shutdown failed", (Throwable)e);
            return;
        }
        this.running = false;
        if (this.workingDir.exists()) {
            this.logger.info((Object)("Deleting working directory " + this.workingDir.getAbsolutePath()));
            this.deleteDir(this.workingDir);
        }
    }

    private void importLdifs() throws Exception {
        String ldifFile;
        Object[] ldifs = this.ctxt == null ? new PathMatchingResourcePatternResolver().getResources(this.ldifResources) : this.ctxt.getResources(this.ldifResources);
        if (ldifs == null || ldifs.length == 0) {
            return;
        }
        if (ldifs.length == 1) {
            try {
                ldifFile = ldifs[0].getFile().getAbsolutePath();
            }
            catch (IOException e) {
                ldifFile = ldifs[0].getURI().toString();
            }
        } else {
            throw new IllegalArgumentException("More than one LDIF resource found with the supplied pattern:" + this.ldifResources + " Got " + Arrays.toString(ldifs));
        }
        this.logger.info((Object)("Loading LDIF file: " + ldifFile));
        LdifFileLoader loader = new LdifFileLoader(this.service.getAdminSession(), new File(ldifFile), null, this.getClass().getClassLoader());
        loader.execute();
    }

    private String createTempDirectory(String prefix) throws IOException {
        String fileNamePrefix;
        String parentTempDir = System.getProperty("java.io.tmpdir");
        String fileName = fileNamePrefix = prefix + System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            File tempDir = new File(parentTempDir, fileName);
            if (!tempDir.exists()) {
                return tempDir.getAbsolutePath();
            }
            fileName = fileNamePrefix + "~" + i;
        }
        throw new IOException("Failed to create a temporary directory for file at " + new File(parentTempDir, fileNamePrefix));
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                boolean success = this.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public boolean isRunning() {
        return this.running;
    }
}

