/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.springframework.cloud.dataflow.server.local.security.ApacheDSContainerWithSecurity;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.SocketUtils;

public class LdapServerResource
extends ExternalResource {
    private static final String LDAP_PORT_PROPERTY = "ldap.port";
    private static final ClassPathResource keyStoreResource = new ClassPathResource("/org/springframework/cloud/dataflow/server/local/security/dataflow.keystore");
    private static final ClassPathResource trustStoreResource = new ClassPathResource("/org/springframework/cloud/dataflow/server/local/security/dataflow.truststore");
    private static final String TRUST_STORE_PASSWORD = "dataflow";
    private static final String KEY_STORE_PASSWORD = "dataflow";
    private String originalLdapPort;
    private ApacheDSContainerWithSecurity apacheDSContainer;
    private TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File workingDir;
    private boolean enabledSsl = false;

    public LdapServerResource() {
    }

    public LdapServerResource(boolean enabledSsl) {
        this.enabledSsl = true;
    }

    protected void before() throws Throwable {
        this.originalLdapPort = System.getProperty(LDAP_PORT_PROPERTY);
        this.temporaryFolder.create();
        this.apacheDSContainer = new ApacheDSContainerWithSecurity("dc=springframework,dc=org", "classpath:org/springframework/cloud/dataflow/server/local/security/testUsers.ldif");
        int ldapPort = SocketUtils.findAvailableTcpPort();
        if (this.enabledSsl) {
            this.apacheDSContainer.setEnabledLdapOverSsl(true);
            File temporaryKeyStoreFile = new File(this.temporaryFolder.getRoot(), "dataflow.keystore");
            File temporaryTrustStoreFile = new File(this.temporaryFolder.getRoot(), "dataflow.truststore");
            FileCopyUtils.copy((InputStream)keyStoreResource.getInputStream(), (OutputStream)new FileOutputStream(temporaryKeyStoreFile));
            FileCopyUtils.copy((InputStream)trustStoreResource.getInputStream(), (OutputStream)new FileOutputStream(temporaryTrustStoreFile));
            Assert.isTrue((boolean)temporaryKeyStoreFile.isFile(), (String)"temporaryKeyStoreFile.isFile can not be null");
            Assert.isTrue((boolean)temporaryTrustStoreFile.isFile(), (String)"temporaryTrustStoreFile.isfile can not be null");
            this.apacheDSContainer.setKeyStoreFile(temporaryKeyStoreFile);
            this.apacheDSContainer.setKeyStorePassword("dataflow");
            System.setProperty("javax.net.ssl.trustStorePassword", "dataflow");
            System.setProperty("javax.net.ssl.trustStore", temporaryTrustStoreFile.getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStoreType", "jks");
        }
        this.apacheDSContainer.setPort(ldapPort);
        this.apacheDSContainer.afterPropertiesSet();
        this.workingDir = new File(this.temporaryFolder.getRoot(), UUID.randomUUID().toString());
        this.apacheDSContainer.setWorkingDirectory(this.workingDir);
        this.apacheDSContainer.start();
        System.setProperty(LDAP_PORT_PROPERTY, Integer.toString(ldapPort));
    }

    protected void after() {
        this.apacheDSContainer.stop();
        try {
            this.apacheDSContainer.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.originalLdapPort != null) {
                System.setProperty(LDAP_PORT_PROPERTY, this.originalLdapPort);
            } else {
                System.clearProperty(LDAP_PORT_PROPERTY);
            }
            System.clearProperty("javax.net.ssl.trustStorePassword");
            System.clearProperty("javax.net.ssl.trustStore");
            System.clearProperty("javax.net.ssl.trustStoreType");
            this.temporaryFolder.delete();
        }
    }
}

