/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local.security;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.cloud.dataflow.server.local.LocalDataflowResource;
import org.springframework.cloud.dataflow.server.local.security.SecurityTestUtils;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LocalServerSecurityRootWithUsersFileTestsWithoutTasksAndStreamsAndMetrics {
    private static final LocalDataflowResource localDataflowResource = new LocalDataflowResource("classpath:org/springframework/cloud/dataflow/server/local/security/fileBasedUsers.yml", false, false, false);
    @ClassRule
    public static TestRule springDataflowAndLdapServer = RuleChain.outerRule((TestRule)localDataflowResource);
    private static UserCredentials viewOnlyUser = new UserCredentials("bob", "bobspassword");
    private static UserCredentials fullUser = new UserCredentials("fulluser", "fullpassword");

    @Test
    public void testAccessRootUrlAndCheckAllLinksWithFullUser() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader(fullUser.getUsername(), fullUser.getPassword())})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.*", (Matcher)Matchers.hasSize((int)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.dashboard.href", (Matcher)Matchers.is((Object)"http://localhost/dashboard"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.streams", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.runtime", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.metrics", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tasks", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.jobs", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tools/parseTaskTextToGraph", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tools/convertTaskGraphToText", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.counters", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.field-value-counters", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.aggregate-counters", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.apps.href", (Matcher)Matchers.is((Object)"http://localhost/apps"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.about.href", (Matcher)Matchers.is((Object)"http://localhost/about"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.completions/stream.href", (Matcher)Matchers.is((Object)"http://localhost/completions/stream{?start,detailLevel}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.completions/task.href", (Matcher)Matchers.is((Object)"http://localhost/completions/task{?start,detailLevel}")));
    }

    @Test
    public void testAccessRootUrlAndCheckAllLinksWithViewOnlyUser() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader(viewOnlyUser.getUsername(), viewOnlyUser.getPassword())})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.*", (Matcher)Matchers.hasSize((int)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.dashboard.href", (Matcher)Matchers.is((Object)"http://localhost/dashboard"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.streams", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.runtime", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.metrics", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tasks", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.jobs", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tools/parseTaskTextToGraph", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tools/convertTaskGraphToText", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.counters", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.field-value-counters", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.aggregate-counters", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.apps.href", (Matcher)Matchers.is((Object)"http://localhost/apps"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.about.href", (Matcher)Matchers.is((Object)"http://localhost/about"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.completions/stream.href", (Matcher)Matchers.is((Object)"http://localhost/completions/stream{?start,detailLevel}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.completions/task.href", (Matcher)Matchers.is((Object)"http://localhost/completions/task{?start,detailLevel}")));
    }
}

