/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local.security;

import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.cloud.dataflow.server.local.LocalDataflowResource;
import org.springframework.cloud.dataflow.server.local.security.LdapServerResource;
import org.springframework.cloud.dataflow.server.local.security.SecurityTestUtils;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@Ignore(value="ssl tests unreliable, see gh1764")
@DirtiesContext(classMode=DirtiesContext.ClassMode.BEFORE_CLASS)
public class LocalServerSecurityWithLdapSearchAndBindSslTests {
    private static final LocalDataflowResource localDataflowResource = new LocalDataflowResource("classpath:org/springframework/cloud/dataflow/server/local/security/ldapSslSearchAndBind.yml");
    @ClassRule
    public static TestRule springDataflowAndLdapServer = RuleChain.outerRule((TestRule)new LdapServerResource(true)).around((TestRule)localDataflowResource);

    @Test
    public void testUnauthenticatedAccessToModulesEndpointFails() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/apps", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testUnauthenticatedAccessToManagementEndpointFails() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/management/metrics", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testAuthenticatedAccessToModulesEndpointSucceeds() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/apps", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("joe", "joespassword")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testUserExistsButNotFoundBySearch() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/apps", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("bob", "bobspassword")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testAuthenticatedAccessToManagementEndpointSucceeds() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/management/metrics", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("joe", "joespassword")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }
}

