/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local.security;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.cloud.dataflow.server.local.LocalDataflowResource;
import org.springframework.cloud.dataflow.server.local.security.LdapServerResource;
import org.springframework.cloud.dataflow.server.local.security.SecurityTestUtils;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LocalServerSecurityWithLdapSimpleBindAndDefaultManagementTests {
    private static final LocalDataflowResource localDataflowResource = new LocalDataflowResource("classpath:org/springframework/cloud/dataflow/server/local/security/ldapSimpleBindWithDefaultManagementSecurity.yml");
    @ClassRule
    public static TestRule springDataflowAndLdapServer = RuleChain.outerRule((TestRule)new LdapServerResource()).around((TestRule)localDataflowResource);

    @Test
    public void testWrongUsernameFails() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/apps", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("joe", "wrongspassword")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testDefaultSpringBootConfigurationFails() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/apps", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("admin", "whosThere")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testWrongPasswordFails() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/apps", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("bob", "bobpassword999")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testUnauthenticatedAccessToAppsEndpointFails() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/apps", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testUnauthenticatedAccessToManagementEndpointFails() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/management/metrics", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testAuthenticatedAccessToAppsEndpointSucceeds() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/apps", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("joe", "joespassword")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testAuthenticatedAccessToManagementEndpointSucceeds() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/management/metrics", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("joe", "joespassword")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }
}

