/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local.security;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.cloud.dataflow.server.local.LocalDataflowResource;
import org.springframework.cloud.dataflow.server.local.security.OAuth2ServerResource;
import org.springframework.cloud.dataflow.server.local.security.SecurityTestUtils;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LocalServerSecurityWithOAuth2Tests {
    private static final OAuth2ServerResource oAuth2ServerResource = new OAuth2ServerResource();
    private static final LocalDataflowResource localDataflowResource = new LocalDataflowResource("classpath:org/springframework/cloud/dataflow/server/local/security/oauthConfig.yml");
    @ClassRule
    public static TestRule springDataflowAndLdapServer = RuleChain.outerRule((TestRule)oAuth2ServerResource).around((TestRule)localDataflowResource);

    @Test
    public void testAccessRootUrlWithoutCredentials() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0])).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testAccessRootUrlWithBasicAuthCredentials() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "secret10")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testAccessRootUrlAndCheckAllLinksWithBasicAuthCredentials() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "secret10")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.dashboard.href", (Matcher)Matchers.is((Object)"http://localhost/dashboard"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.streams/definitions.href", (Matcher)Matchers.is((Object)"http://localhost/streams/definitions"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.streams/definitions/definition.href", (Matcher)Matchers.is((Object)"http://localhost/streams/definitions/{name}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.streams/deployments.href", (Matcher)Matchers.is((Object)"http://localhost/streams/deployments"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.streams/deployments/deployment.href", (Matcher)Matchers.is((Object)"http://localhost/streams/deployments/{name}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.runtime/apps.href", (Matcher)Matchers.is((Object)"http://localhost/runtime/apps"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.runtime/apps/app.href", (Matcher)Matchers.is((Object)"http://localhost/runtime/apps/{appId}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.runtime/apps/instances.href", (Matcher)Matchers.is((Object)"http://localhost/runtime/apps/{appId}/instances"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.metrics/streams.href", (Matcher)Matchers.is((Object)"http://localhost/metrics/streams"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tasks/definitions.href", (Matcher)Matchers.is((Object)"http://localhost/tasks/definitions"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tasks/definitions/definition.href", (Matcher)Matchers.is((Object)"http://localhost/tasks/definitions/{name}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tasks/executions.href", (Matcher)Matchers.is((Object)"http://localhost/tasks/executions"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tasks/executions/name.href", (Matcher)Matchers.is((Object)"http://localhost/tasks/executions{?name}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tasks/executions/execution.href", (Matcher)Matchers.is((Object)"http://localhost/tasks/executions/{id}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.jobs/executions.href", (Matcher)Matchers.is((Object)"http://localhost/jobs/executions"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.jobs/executions/name.href", (Matcher)Matchers.is((Object)"http://localhost/jobs/executions{?name}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.jobs/executions/execution.href", (Matcher)Matchers.is((Object)"http://localhost/jobs/executions/{id}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.jobs/executions/execution/steps.href", (Matcher)Matchers.is((Object)"http://localhost/jobs/executions/{jobExecutionId}/steps"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.jobs/executions/execution/steps/step.href", (Matcher)Matchers.is((Object)"http://localhost/jobs/executions/{jobExecutionId}/steps/{stepId}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.jobs/executions/execution/steps/step/progress.href", (Matcher)Matchers.is((Object)"http://localhost/jobs/executions/{jobExecutionId}/steps/{stepId}/progress"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.jobs/instances/name.href", (Matcher)Matchers.is((Object)"http://localhost/jobs/instances{?name}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.jobs/instances/instance.href", (Matcher)Matchers.is((Object)"http://localhost/jobs/instances/{id}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tools/parseTaskTextToGraph.href", (Matcher)Matchers.is((Object)"http://localhost/tools"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.tools/convertTaskGraphToText.href", (Matcher)Matchers.is((Object)"http://localhost/tools"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.counters.href", (Matcher)Matchers.is((Object)"http://localhost/metrics/counters"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.counters/counter.href", (Matcher)Matchers.is((Object)"http://localhost/metrics/counters/{name}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.field-value-counters.href", (Matcher)Matchers.is((Object)"http://localhost/metrics/field-value-counters"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.field-value-counters/counter.href", (Matcher)Matchers.is((Object)"http://localhost/metrics/field-value-counters/{name}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.aggregate-counters.href", (Matcher)Matchers.is((Object)"http://localhost/metrics/aggregate-counters"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.aggregate-counters/counter.href", (Matcher)Matchers.is((Object)"http://localhost/metrics/aggregate-counters/{name}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.apps.href", (Matcher)Matchers.is((Object)"http://localhost/apps"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.about.href", (Matcher)Matchers.is((Object)"http://localhost/about"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.completions/stream.href", (Matcher)Matchers.is((Object)"http://localhost/completions/stream{?start,detailLevel}"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.completions/task.href", (Matcher)Matchers.is((Object)"http://localhost/completions/task{?start,detailLevel}")));
    }

    @Test
    public void testAccessRootUrlWithBasicAuthCredentialsWrongPassword() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "wrong-password")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testThatAccessToActuatorEndpointPromptsSecurity() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/management/env", (Object[])new Object[0])).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testAccessToActuatorEndpointWithBasicAuthCredentialsWrongPassword() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/management/env", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "wrong-password")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testThatAccessToActuatorEndpointWithBasicAuthCredentialsSucceeds() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/management/env", (Object[])new Object[0]).header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader("user", "secret10")})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testAccessRootUrlWithOAuth2AccessToken() throws Exception {
        ClientCredentialsResourceDetails resourceDetails = new ClientCredentialsResourceDetails();
        resourceDetails.setClientId("myclient");
        resourceDetails.setClientSecret("mysecret");
        resourceDetails.setGrantType("client_credentials");
        resourceDetails.setAccessTokenUri("http://localhost:" + oAuth2ServerResource.getOauth2ServerPort() + "/oauth/token");
        OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resourceDetails);
        OAuth2AccessToken accessToken = oAuth2RestTemplate.getAccessToken();
        String accessTokenAsString = accessToken.getValue();
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).header("Authorization", new Object[]{"bearer " + accessTokenAsString})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testAccessSecurityInfoUrlWithOAuth2AccessToken() throws Exception {
        ClientCredentialsResourceDetails resourceDetails = new ClientCredentialsResourceDetails();
        resourceDetails.setClientId("myclient");
        resourceDetails.setClientSecret("mysecret");
        resourceDetails.setGrantType("client_credentials");
        resourceDetails.setAccessTokenUri("http://localhost:" + oAuth2ServerResource.getOauth2ServerPort() + "/oauth/token");
        OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resourceDetails);
        OAuth2AccessToken accessToken = oAuth2RestTemplate.getAccessToken();
        String accessTokenAsString = accessToken.getValue();
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/security/info", (Object[])new Object[0]).header("Authorization", new Object[]{"bearer " + accessTokenAsString})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authorizationEnabled", (Matcher)Matchers.is((Object)Boolean.TRUE))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)Boolean.TRUE))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationEnabled", (Matcher)Matchers.is((Object)Boolean.TRUE))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.roles", (Matcher)Matchers.hasSize((int)3)));
    }

    @Test
    public void testAccessRootUrlWithWrongOAuth2AccessToken() throws Exception {
        localDataflowResource.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).header("Authorization", new Object[]{"bearer 123456"})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

