/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.server.local.LocalDataflowResource;
import org.springframework.cloud.dataflow.server.local.TestUtils;
import org.springframework.cloud.dataflow.server.local.security.SecurityTestUtils;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.util.CollectionUtils;

@RunWith(value=Parameterized.class)
public class LocalServerSecurityWithSingleUserTests {
    private static final Logger logger = LoggerFactory.getLogger(LocalServerSecurityWithSingleUserTests.class);
    private static final LocalDataflowResource localDataflowResource = new LocalDataflowResource("classpath:org/springframework/cloud/dataflow/server/local/security/singleUser.yml");
    @ClassRule
    public static TestRule springDataflowAndLdapServer = RuleChain.outerRule((TestRule)localDataflowResource);
    private static UserCredentials singleUser = new UserCredentials("user", "password");
    @Parameterized.Parameter(value=0)
    public HttpMethod httpMethod;
    @Parameterized.Parameter(value=1)
    public HttpStatus expectedHttpStatus;
    @Parameterized.Parameter(value=2)
    public String url;
    @Parameterized.Parameter(value=3)
    public UserCredentials userCredentials;
    @Parameterized.Parameter(value=4)
    public Map<String, String> urlParameters;

    @Parameterized.Parameters(name="Authentication Test {index} - {0} {2} - Returns: {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({HttpMethod.GET, HttpStatus.OK, "/", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/", null, null}, {HttpMethod.GET, HttpStatus.OK, "/apps", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/apps", null, null}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/apps/task/taskname", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/apps/task/taskname", null, null}, {HttpMethod.POST, HttpStatus.BAD_REQUEST, "/apps/task/taskname", singleUser, null}, {HttpMethod.POST, HttpStatus.CREATED, "/apps/task/taskname", singleUser, TestUtils.toImmutableMap("uri", "maven://io.spring.cloud:scdf-sample-app:jar:1.0.0.BUILD-SNAPSHOT", "force", "false")}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/apps/task/taskname", null, null}, {HttpMethod.DELETE, HttpStatus.OK, "/apps/task/taskname", singleUser, null}, {HttpMethod.DELETE, HttpStatus.UNAUTHORIZED, "/apps/task/taskname", null, null}, {HttpMethod.POST, HttpStatus.CREATED, "/apps", singleUser, TestUtils.toImmutableMap("uri", "http://bit.ly/1-0-2-GA-stream-applications-rabbit-maven", "apps", "app=is_ignored", "force", "false")}, {HttpMethod.POST, HttpStatus.CREATED, "/apps", singleUser, TestUtils.toImmutableMap("uri", "http://bit.ly/1-0-2-GA-stream-applications-rabbit-maven", "force", "false")}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/apps", null, TestUtils.toImmutableMap("uri", "???", "apps", "??", "force", "true")}, {HttpMethod.GET, HttpStatus.BAD_REQUEST, "/completions/stream", singleUser, null}, {HttpMethod.GET, HttpStatus.OK, "/completions/stream", singleUser, TestUtils.toImmutableMap("start", "2")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/completions/stream", null, null}, {HttpMethod.GET, HttpStatus.BAD_REQUEST, "/completions/task", singleUser, null}, {HttpMethod.GET, HttpStatus.OK, "/completions/task", singleUser, TestUtils.toImmutableMap("start", "2")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/completions/task", null, null}, {HttpMethod.GET, HttpStatus.OK, "/completions/stream", singleUser, TestUtils.toImmutableMap("start", "2", "detailLevel", "2")}, {HttpMethod.GET, HttpStatus.BAD_REQUEST, "/completions/stream", singleUser, TestUtils.toImmutableMap("start", "2", "detailLevel", "-123")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/completions/stream", null, TestUtils.toImmutableMap("detailLevel", "2")}, {HttpMethod.GET, HttpStatus.OK, "/completions/task", singleUser, TestUtils.toImmutableMap("start", "2", "detailLevel", "2")}, {HttpMethod.GET, HttpStatus.BAD_REQUEST, "/completions/task", singleUser, TestUtils.toImmutableMap("start", "2", "detailLevel", "-123")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/completions/task", null, TestUtils.toImmutableMap("detailLevel", "2")}, {HttpMethod.GET, HttpStatus.FORBIDDEN, "/tools/parseTaskTextToGraph", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/tools/parseTaskTextToGraph", null, null}, {HttpMethod.GET, HttpStatus.FORBIDDEN, "/tools/convertTaskGraphToText", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/tools/convertTaskGraphToText", null, null}, {HttpMethod.GET, HttpStatus.FORBIDDEN, "/tools/parseTaskTextToGraph", singleUser, TestUtils.toImmutableMap("definition", "fooApp")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/tools/parseTaskTextToGraph", null, TestUtils.toImmutableMap("definition", "fooApp")}, {HttpMethod.GET, HttpStatus.FORBIDDEN, "/tools/convertTaskGraphToText", singleUser, TestUtils.toImmutableMap("detailLevel", "2")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/tools/convertTaskGraphToText", null, TestUtils.toImmutableMap("detailLevel", "2")}, {HttpMethod.PUT, HttpStatus.FORBIDDEN, "/tools/parseTaskTextToGraph", singleUser, null}, {HttpMethod.PUT, HttpStatus.FORBIDDEN, "/tools/parseTaskTextToGraph", singleUser, TestUtils.toImmutableMap("name", "foo", "dsl", "t1 || t2")}, {HttpMethod.PUT, HttpStatus.FORBIDDEN, "/tools/convertTaskGraphToText", singleUser, null}, {HttpMethod.PUT, HttpStatus.FORBIDDEN, "/tools/convertTaskGraphToText", singleUser, TestUtils.toImmutableMap("detailLevel", "2")}, {HttpMethod.POST, HttpStatus.BAD_REQUEST, "/tools/parseTaskTextToGraph", singleUser, TestUtils.toImmutableMap("name", "foo", "dsl", "t1 && t2")}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/tools/parseTaskTextToGraph", null, null}, {HttpMethod.POST, HttpStatus.BAD_REQUEST, "/tools/convertTaskGraphToText", singleUser, null}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/tools/convertTaskGraphToText", null, null}, {HttpMethod.GET, HttpStatus.OK, "/jobs/executions", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/executions", null, null}, {HttpMethod.GET, HttpStatus.OK, "/jobs/executions", singleUser, TestUtils.toImmutableMap("page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/executions", null, TestUtils.toImmutableMap("page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/jobs/executions", singleUser, TestUtils.toImmutableMap("name", "myname")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/executions", null, TestUtils.toImmutableMap("name", "myname")}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/jobs/executions", singleUser, TestUtils.toImmutableMap("name", "myname", "page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/executions", null, TestUtils.toImmutableMap("name", "myname", "page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/jobs/executions/123", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/executions/123", null, null}, {HttpMethod.PUT, HttpStatus.NOT_FOUND, "/jobs/executions/123", singleUser, TestUtils.toImmutableMap("stop", "true")}, {HttpMethod.PUT, HttpStatus.UNAUTHORIZED, "/jobs/executions/123", null, TestUtils.toImmutableMap("stop", "true")}, {HttpMethod.PUT, HttpStatus.NOT_FOUND, "/jobs/executions/123", singleUser, TestUtils.toImmutableMap("restart", "true")}, {HttpMethod.PUT, HttpStatus.UNAUTHORIZED, "/jobs/executions/123", null, TestUtils.toImmutableMap("restart", "true")}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/jobs/instances", singleUser, TestUtils.toImmutableMap("name", "my-job-name")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/instances", null, TestUtils.toImmutableMap("name", "my-job-name")}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/jobs/instances", singleUser, TestUtils.toImmutableMap("name", "my-job-name", "page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/instances", null, TestUtils.toImmutableMap("name", "my-job-name", "page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.BAD_REQUEST, "/jobs/instances", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/instances", null, null}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/jobs/instances/123", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/instances/123", null, null}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/jobs/executions/123/steps", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/executions/123/steps", null, null}, {HttpMethod.GET, HttpStatus.BAD_REQUEST, "/jobs/executions/abc/steps", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/executions/abc/steps", null, null}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/jobs/executions/123/steps", singleUser, TestUtils.toImmutableMap("name", "my-job-name", "page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/executions/123/steps", null, TestUtils.toImmutableMap("name", "my-job-name", "page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/jobs/executions/123/steps/1", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/executions/123/steps/1", null, null}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/jobs/executions/123/steps/1/progress", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/jobs/executions/123/steps/1/progress", null, null}, {HttpMethod.GET, HttpStatus.OK, "/runtime/apps", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/runtime/apps", null, null}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/runtime/apps/123", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/runtime/apps/123", null, null}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/runtime/apps/123/instances", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/runtime/apps/123/instances", null, null}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/runtime/apps/123/instances/456", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/runtime/apps/123/instances/456", null, null}, {HttpMethod.GET, HttpStatus.OK, "/streams/definitions", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/streams/definitions", null, null}, {HttpMethod.GET, HttpStatus.OK, "/streams/definitions", singleUser, TestUtils.toImmutableMap("page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/streams/definitions", null, TestUtils.toImmutableMap("page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.OK, "/streams/definitions", singleUser, TestUtils.toImmutableMap("search", "mysearch")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/streams/definitions", null, TestUtils.toImmutableMap("search", "mysearch")}, {HttpMethod.POST, HttpStatus.BAD_REQUEST, "/streams/definitions", singleUser, TestUtils.toImmutableMap("name", "myname", "definition", "fooo | baaar")}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/streams/definitions", null, TestUtils.toImmutableMap("name", "myname", "definition", "fooo | baaar")}, {HttpMethod.POST, HttpStatus.BAD_REQUEST, "/streams/definitions", singleUser, TestUtils.toImmutableMap("name", "myname")}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/streams/definitions", null, TestUtils.toImmutableMap("name", "myname")}, {HttpMethod.DELETE, HttpStatus.NOT_FOUND, "/streams/definitions/delete-me", singleUser, null}, {HttpMethod.DELETE, HttpStatus.UNAUTHORIZED, "/streams/definitions/delete-me", null, null}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/streams/definitions/my-stream/related", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/streams/definitions/my-stream/related", null, null}, {HttpMethod.GET, HttpStatus.BAD_REQUEST, "/streams/definitions/my-stream/related", singleUser, TestUtils.toImmutableMap("nested", "wrong-param")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/streams/definitions/my-stream/related", null, TestUtils.toImmutableMap("nested", "wrong-param")}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/streams/definitions/my-stream", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/streams/definitions/my-stream", null, null}, {HttpMethod.DELETE, HttpStatus.OK, "/streams/definitions", singleUser, null}, {HttpMethod.DELETE, HttpStatus.UNAUTHORIZED, "/streams/definitions", null, null}, {HttpMethod.DELETE, HttpStatus.OK, "/streams/deployments", singleUser, null}, {HttpMethod.DELETE, HttpStatus.UNAUTHORIZED, "/streams/deployments", null, null}, {HttpMethod.DELETE, HttpStatus.NOT_FOUND, "/streams/deployments/my-stream", singleUser, null}, {HttpMethod.DELETE, HttpStatus.UNAUTHORIZED, "/streams/deployments/my-stream", null, null}, {HttpMethod.POST, HttpStatus.NOT_FOUND, "/streams/deployments/my-stream", singleUser, null}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/streams/deployments/my-stream", null, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/streams/deployments/history/my-stream/2", null, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/streams/deployments/manifest/my-stream/2", null, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/streams/deployments/platform/list", null, null}, {HttpMethod.POST, HttpStatus.BAD_REQUEST, "/tasks/definitions", singleUser, TestUtils.toImmutableMap("name", "my-name")}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/tasks/definitions", null, TestUtils.toImmutableMap("name", "my-name")}, {HttpMethod.POST, HttpStatus.NOT_FOUND, "/tasks/definitions", singleUser, TestUtils.toImmutableMap("name", "my-name", "definition", "foo")}, {HttpMethod.POST, HttpStatus.BAD_REQUEST, "/tasks/definitions", singleUser, null}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/tasks/definitions", null, TestUtils.toImmutableMap("name", "my-name", "definition", "foo")}, {HttpMethod.GET, HttpStatus.OK, "/tasks/executions", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/tasks/executions", null, null}, {HttpMethod.GET, HttpStatus.OK, "/tasks/executions", singleUser, TestUtils.toImmutableMap("page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/tasks/executions", null, TestUtils.toImmutableMap("page", "0", "size", "10")}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/tasks/executions", singleUser, TestUtils.toImmutableMap("name", "my-task-name")}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/tasks/executions", null, TestUtils.toImmutableMap("name", "my-task-name")}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/tasks/executions/123", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/tasks/executions/123", null, null}, {HttpMethod.DELETE, HttpStatus.NOT_FOUND, "/tasks/executions/123", singleUser, null}, {HttpMethod.DELETE, HttpStatus.UNAUTHORIZED, "/tasks/executions/123", null, null}, {HttpMethod.POST, HttpStatus.BAD_REQUEST, "/tasks/executions", singleUser, null}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/tasks/executions", null, null}, {HttpMethod.POST, HttpStatus.NOT_FOUND, "/tasks/executions", singleUser, TestUtils.toImmutableMap("name", "my-task-name")}, {HttpMethod.POST, HttpStatus.UNAUTHORIZED, "/tasks/executions", null, TestUtils.toImmutableMap("name", "my-task-name")}, {HttpMethod.GET, HttpStatus.FOUND, "/dashboard", singleUser, null}, {HttpMethod.GET, HttpStatus.FOUND, "/dashboard", null, null}, {HttpMethod.GET, HttpStatus.OK, "/about", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/about", null, null}, {HttpMethod.GET, HttpStatus.OK, "/management", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/management", null, null}, {HttpMethod.GET, HttpStatus.OK, "/management/info", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/management/info", null, null}, {HttpMethod.GET, HttpStatus.NOT_FOUND, "/management/does-not-exist", singleUser, null}, {HttpMethod.GET, HttpStatus.UNAUTHORIZED, "/management/does-not-exist", null, null}, {HttpMethod.POST, HttpStatus.BAD_REQUEST, "/authenticate", singleUser, null}, {HttpMethod.POST, HttpStatus.BAD_REQUEST, "/authenticate", null, null}, {HttpMethod.GET, HttpStatus.OK, "/security/info", singleUser, null}, {HttpMethod.GET, HttpStatus.OK, "/security/info", null, null});
    }

    @Test
    public void testEndpointAuthentication() throws Exception {
        ResultMatcher statusResultMatcher;
        MockHttpServletRequestBuilder rb;
        logger.info(String.format("Using parameters - httpMethod: %s, URL: %s, URL parameters: %s, user credentials: %s", this.httpMethod, this.url, this.urlParameters, this.userCredentials));
        switch (this.httpMethod) {
            case GET: {
                rb = MockMvcRequestBuilders.get((String)this.url, (Object[])new Object[0]);
                break;
            }
            case POST: {
                rb = MockMvcRequestBuilders.post((String)this.url, (Object[])new Object[0]);
                break;
            }
            case PUT: {
                rb = MockMvcRequestBuilders.put((String)this.url, (Object[])new Object[0]);
                break;
            }
            case DELETE: {
                rb = MockMvcRequestBuilders.delete((String)this.url, (Object[])new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Method: " + this.httpMethod);
            }
        }
        if (this.userCredentials != null) {
            rb.header("Authorization", new Object[]{SecurityTestUtils.basicAuthorizationHeader(this.userCredentials.getUsername(), this.userCredentials.getPassword())});
        }
        if (!CollectionUtils.isEmpty(this.urlParameters)) {
            for (Map.Entry<String, String> mapEntry : this.urlParameters.entrySet()) {
                rb.param(mapEntry.getKey(), new String[]{mapEntry.getValue()});
            }
        }
        switch (this.expectedHttpStatus) {
            case UNAUTHORIZED: {
                statusResultMatcher = MockMvcResultMatchers.status().isUnauthorized();
                break;
            }
            case FORBIDDEN: {
                statusResultMatcher = MockMvcResultMatchers.status().isForbidden();
                break;
            }
            case FOUND: {
                statusResultMatcher = MockMvcResultMatchers.status().isFound();
                break;
            }
            case NOT_FOUND: {
                statusResultMatcher = MockMvcResultMatchers.status().isNotFound();
                break;
            }
            case OK: {
                statusResultMatcher = MockMvcResultMatchers.status().isOk();
                break;
            }
            case CREATED: {
                statusResultMatcher = MockMvcResultMatchers.status().isCreated();
                break;
            }
            case BAD_REQUEST: {
                statusResultMatcher = MockMvcResultMatchers.status().isBadRequest();
                break;
            }
            case INTERNAL_SERVER_ERROR: {
                statusResultMatcher = MockMvcResultMatchers.status().isInternalServerError();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Status: " + this.expectedHttpStatus);
            }
        }
        try {
            localDataflowResource.getMockMvc().perform((RequestBuilder)rb).andDo(MockMvcResultHandlers.print()).andExpect(statusResultMatcher);
        }
        catch (AssertionError e) {
            throw new AssertionError(String.format("Assertion failed for parameters - httpMethod: %s, URL: %s, URL parameters: %s, user credentials: %s", this.httpMethod, this.url, this.urlParameters, this.userCredentials), (Throwable)((Object)e));
        }
    }
}

