/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.local;

import java.util.Collection;
import javax.servlet.Filter;
import org.junit.rules.ExternalResource;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.dataflow.server.local.dataflowapp.LocalTestDataFlowServer;
import org.springframework.context.ApplicationContext;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public class LocalDataflowResource
extends ExternalResource {
    final boolean streamsEnabled;
    final boolean tasksEnabled;
    final boolean metricsEnabled;
    final boolean schedulerEnabled;
    final boolean skipperEnabled;
    private String originalConfigLocation = null;
    private SpringApplication app;
    private MockMvc mockMvc;
    private String dataflowPort;
    private String skipperServerPort;
    private String configurationLocation;
    private WebApplicationContext configurableApplicationContext;

    public LocalDataflowResource(String configurationLocation) {
        this.configurationLocation = configurationLocation;
        this.streamsEnabled = true;
        this.tasksEnabled = true;
        this.metricsEnabled = true;
        this.schedulerEnabled = false;
        this.skipperEnabled = false;
    }

    public LocalDataflowResource(String configurationLocation, boolean streamsEnabled, boolean tasksEnabled) {
        this.configurationLocation = configurationLocation;
        this.streamsEnabled = streamsEnabled;
        this.tasksEnabled = tasksEnabled;
        this.metricsEnabled = true;
        this.schedulerEnabled = false;
        this.skipperEnabled = false;
    }

    public LocalDataflowResource(String configurationLocation, boolean streamsEnabled, boolean tasksEnabled, boolean metricsEnabled) {
        this.configurationLocation = configurationLocation;
        this.streamsEnabled = streamsEnabled;
        this.tasksEnabled = tasksEnabled;
        this.metricsEnabled = metricsEnabled;
        this.schedulerEnabled = false;
        this.skipperEnabled = false;
    }

    public LocalDataflowResource(String configurationLocation, boolean streamsEnabled, boolean tasksEnabled, boolean metricsEnabled, boolean schedulerEnabled) {
        this.configurationLocation = configurationLocation;
        this.streamsEnabled = streamsEnabled;
        this.tasksEnabled = tasksEnabled;
        this.metricsEnabled = metricsEnabled;
        this.schedulerEnabled = schedulerEnabled;
        this.skipperEnabled = false;
    }

    public LocalDataflowResource(String configurationLocation, boolean streamsEnabled, boolean tasksEnabled, boolean metricsEnabled, boolean schedulerEnabled, boolean skipperEnabled, String skipperServerPort) {
        this.configurationLocation = configurationLocation;
        this.streamsEnabled = streamsEnabled;
        this.tasksEnabled = tasksEnabled;
        this.metricsEnabled = metricsEnabled;
        this.schedulerEnabled = schedulerEnabled;
        this.skipperEnabled = skipperEnabled;
        this.skipperServerPort = skipperServerPort;
    }

    protected void before() throws Throwable {
        this.originalConfigLocation = System.getProperty("spring.config.location");
        if (!StringUtils.isEmpty((Object)this.configurationLocation)) {
            System.setProperty("spring.config.location", this.configurationLocation);
        }
        this.app = new SpringApplication(new Object[]{LocalTestDataFlowServer.class});
        this.configurableApplicationContext = (WebApplicationContext)this.app.run(new String[]{"--server.port=0", "--spring.cloud.dataflow.features.streams-enabled=" + this.streamsEnabled, "--spring.cloud.dataflow.features.tasks-enabled=" + this.tasksEnabled, "--spring.cloud.dataflow.features.analytics-enabled=" + this.metricsEnabled, "--spring.cloud.dataflow.features.schedules-enabled=" + this.schedulerEnabled, "--spring.cloud.dataflow.features.skipper-enabled=" + this.skipperEnabled, "--spring.cloud.skipper.client.serverUri=http://localhost:" + this.skipperServerPort + "/api"});
        Collection filters = this.configurableApplicationContext.getBeansOfType(Filter.class).values();
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.configurableApplicationContext).addFilters(filters.toArray(new Filter[filters.size()]))).build();
        this.dataflowPort = this.configurableApplicationContext.getEnvironment().resolvePlaceholders("${server.port}");
    }

    protected void after() {
        SpringApplication.exit((ApplicationContext)this.configurableApplicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        this.resetConfigLocation();
    }

    private void resetConfigLocation() {
        if (this.originalConfigLocation != null) {
            System.setProperty("spring.config.location", this.originalConfigLocation);
        } else {
            System.clearProperty("spring.config.location");
        }
    }

    public MockMvc getMockMvc() {
        return this.mockMvc;
    }

    public String getDataflowPort() {
        return this.dataflowPort;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this.configurableApplicationContext;
    }
}

