/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.elasticsearch.core.query;

import org.elasticsearch.index.query.FilterBuilder;

import java.util.Map;
/**
 *
 * @author Mohsin Husen
 */
public class AliasBuilder {

    private String indexName;
    private String aliasName;
    private FilterBuilder filterBuilder;
    private Map<String, Object> filter;

    public AliasBuilder withIndexName(String indexName){
        this.indexName = indexName;
        return this;
    }

    public AliasBuilder withAliasName(String aliasName){
        this.aliasName = aliasName;
        return this;
    }

    public AliasBuilder withFilterBuilder(FilterBuilder filterBuilder){
        this.filterBuilder = filterBuilder;
        return this;
    }

    public  AliasBuilder withFilter(Map<String, Object> filter){
        this.filter = filter;
        return this;
    }

    public AliasQuery build(){
        AliasQuery aliasQuery = new AliasQuery();
        aliasQuery.setIndexName(indexName);
        aliasQuery.setAliasName(aliasName);
        aliasQuery.setFilterBuilder(filterBuilder);
        aliasQuery.setFilter(filter);
        return aliasQuery;
    }
}
