/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.ArithmeticOperators;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.ReplaceWithOperation;
import org.springframework.data.mongodb.core.aggregation.SetOperation;
import org.springframework.data.mongodb.core.aggregation.UnsetOperation;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AggregationUpdate
extends Aggregation
implements UpdateDefinition {
    private boolean isolated = false;
    private Set<String> keysTouched = new HashSet<String>();

    protected AggregationUpdate() {
        this(new ArrayList<AggregationOperation>());
    }

    protected AggregationUpdate(List<AggregationOperation> pipeline) {
        super(pipeline);
        for (AggregationOperation operation : pipeline) {
            if (!(operation instanceof FieldsExposingAggregationOperation)) continue;
            ((FieldsExposingAggregationOperation)operation).getFields().forEach(it -> this.keysTouched.add(it.getName()));
        }
    }

    public static AggregationUpdate update() {
        return new AggregationUpdate();
    }

    public static AggregationUpdate from(List<AggregationOperation> pipeline) {
        return new AggregationUpdate(pipeline);
    }

    public AggregationUpdate set(SetOperation setOperation) {
        Assert.notNull((Object)setOperation, (String)"SetOperation must not be null!");
        setOperation.getFields().forEach(it -> this.keysTouched.add(it.getName()));
        this.operations.add(setOperation);
        return this;
    }

    public AggregationUpdate unset(UnsetOperation unsetOperation) {
        Assert.notNull((Object)unsetOperation, (String)"UnsetOperation must not be null!");
        this.operations.add(unsetOperation);
        this.keysTouched.addAll(unsetOperation.removedFieldNames());
        return this;
    }

    public AggregationUpdate replaceWith(ReplaceWithOperation replaceWithOperation) {
        Assert.notNull((Object)replaceWithOperation, (String)"ReplaceWithOperation must not be null!");
        this.operations.add(replaceWithOperation);
        return this;
    }

    public AggregationUpdate replaceWith(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.replaceWith(ReplaceWithOperation.replaceWithValue(value));
    }

    public SetValueAppender set(final String key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new SetValueAppender(){

            @Override
            public AggregationUpdate toValue(@Nullable Object value) {
                return AggregationUpdate.this.set(SetOperation.builder().set(key).toValue(value));
            }

            @Override
            public AggregationUpdate toValueOf(Object value) {
                Assert.notNull((Object)value, (String)"Value must not be null!");
                return AggregationUpdate.this.set(SetOperation.builder().set(key).toValueOf(value));
            }
        };
    }

    public AggregationUpdate unset(String ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements.");
        return this.unset(new UnsetOperation(Arrays.stream(keys).map(Fields::field).collect(Collectors.toList())));
    }

    public AggregationUpdate isolated() {
        this.isolated = true;
        return this;
    }

    @Override
    public Boolean isIsolated() {
        return this.isolated;
    }

    @Override
    public Document getUpdateObject() {
        return new Document("", this.toPipeline(Aggregation.DEFAULT_CONTEXT));
    }

    @Override
    public boolean modifies(String key) {
        return this.keysTouched.contains(key);
    }

    @Override
    public void inc(String key) {
        this.set(new SetOperation(key, ArithmeticOperators.valueOf(key).add(1)));
    }

    @Override
    public List<UpdateDefinition.ArrayFilter> getArrayFilters() {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(",\n", "[\n", "\n]");
        this.toPipeline(Aggregation.DEFAULT_CONTEXT).stream().map(SerializationUtils::serializeToJsonSafely).forEach(joiner::add);
        return joiner.toString();
    }

    public static interface SetValueAppender {
        public AggregationUpdate toValue(@Nullable Object var1);

        public AggregationUpdate toValueOf(Object var1);
    }
}

